/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiPointTypeBindingTest
extends GML3TestSupport {
    public void test() throws Exception {
        GML3MockData.multiPoint(this.document, this.document);
        MultiPoint multiPoint = (MultiPoint)this.parse();
        MultiPointTypeBindingTest.assertNotNull((Object)multiPoint);
        MultiPointTypeBindingTest.assertEquals((int)4, (int)multiPoint.getNumPoints());
    }

    public void test3D() throws Exception {
        GML3MockData.multiPoint3D(this.document, this.document);
        MultiPoint multiPoint = (MultiPoint)this.parse();
        MultiPointTypeBindingTest.assertNotNull((Object)multiPoint);
        MultiPointTypeBindingTest.assertEquals((int)4, (int)multiPoint.getNumPoints());
        Point p = (Point)multiPoint.getGeometryN(0);
        MultiPointTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(p.getCoordinate()));
    }

    public void testEncode() throws Exception {
        MultiPoint geometry = GML3MockData.multiPoint();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiPoint);
        MultiPointTypeBindingTest.assertEquals((String)"geometry", (String)this.getID(dom.getDocumentElement()));
        MultiPointTypeBindingTest.assertEquals((int)2, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "pointMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Point.getLocalPart());
        MultiPointTypeBindingTest.assertEquals((int)2, (int)children.getLength());
        MultiPointTypeBindingTest.assertEquals((String)"geometry.1", (String)this.getID(children.item(0)));
        MultiPointTypeBindingTest.assertEquals((String)"geometry.2", (String)this.getID(children.item(1)));
    }
}

