/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiPolygonEncoder;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class MultiPolygonTest
extends GeometryEncoderTestSupport {
    public void testEncodeMultiPolygon() throws Exception {
        MultiPolygonEncoder encoder = new MultiPolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("MULTIPOLYGON(((1 1,5 1,5 5,1 5,1 1),(2 2, 3 2, 3 3, 2 3,2 2)),((3 3,6 2,6 4,3 3)))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "mpoly");
        MultiPolygonTest.assertEquals((String)"1 1 5 1 5 5 1 5 1 1", (String)this.xpath.evaluate("/gml:MultiSurface/gml:surfaceMember[1]/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc));
        MultiPolygonTest.assertEquals((String)"mpoly", (String)this.xpath.evaluate("/gml:MultiSurface/@gml:id", doc));
        MultiPolygonTest.assertEquals((String)"mpoly.1", (String)this.xpath.evaluate("/gml:MultiSurface/gml:surfaceMember[1]/gml:Polygon/@gml:id", doc));
        MultiPolygonTest.assertEquals((String)"mpoly.2", (String)this.xpath.evaluate("/gml:MultiSurface/gml:surfaceMember[2]/gml:Polygon/@gml:id", doc));
    }

    public void testEncodeMultiPolygonNoGmlId() throws Exception {
        MultiPolygonEncoder encoder = new MultiPolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        Geometry geometry = new WKTReader2().read("MULTIPOLYGON(((1 1,5 1,5 5,1 5,1 1),(2 2, 3 2, 3 3, 2 3,2 2)),((3 3,6 2,6 4,3 3)))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "mpoly");
        MultiPolygonTest.assertEquals((String)"0", (String)this.xpath.evaluate("count(/gml:MultiSurface/gml:surfaceMember/gml:Polygon/@gml:id)", doc));
    }
}

