/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class MultiPointTest
extends GeometryEncoderTestSupport {
    public void testEncodeMultiPoint() throws Exception {
        MultiPointEncoder encoder = new MultiPointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("MULTIPOINT(0 0, 1 1)");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "points");
        MultiPointTest.assertEquals((String)"0 0", (String)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[1]/gml:Point/gml:pos", doc));
        MultiPointTest.assertEquals((String)"1 1", (String)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[2]/gml:Point/gml:pos", doc));
        MultiPointTest.assertEquals((String)"points", (String)this.xpath.evaluate("/gml:MultiPoint/@gml:id", doc));
        MultiPointTest.assertEquals((String)"points.1", (String)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[1]/gml:Point/@gml:id", doc));
        MultiPointTest.assertEquals((String)"points.2", (String)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[2]/gml:Point/@gml:id", doc));
    }

    public void testEncodeMultiPointNoGmlId() throws Exception {
        MultiPointEncoder encoder = new MultiPointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        Geometry geometry = new WKTReader2().read("MULTIPOINT(0 0, 1 1)");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "points");
        MultiPointTest.assertEquals((String)"0", (String)this.xpath.evaluate("count(//gml:MultiPoint/gml:pointMember/gml:Point/@gml:id)", doc));
    }
}

