/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiPolygonTypeBindingTest
extends GML3TestSupport {
    public void test() throws Exception {
        GML3MockData.multiPolygon(this.document, this.document);
        MultiPolygon multiPolygon = (MultiPolygon)this.parse();
        MultiPolygonTypeBindingTest.assertNotNull((Object)multiPolygon);
        MultiPolygonTypeBindingTest.assertEquals((int)2, (int)multiPolygon.getNumGeometries());
    }

    public void test3D() throws Exception {
        GML3MockData.multiPolygon3D(this.document, this.document);
        MultiPolygon multiPolygon = (MultiPolygon)this.parse();
        MultiPolygonTypeBindingTest.assertNotNull((Object)multiPolygon);
        MultiPolygonTypeBindingTest.assertEquals((int)2, (int)multiPolygon.getNumGeometries());
        Polygon polygon = (Polygon)multiPolygon.getGeometryN(0);
        LineString exterior = polygon.getExteriorRing();
        MultiPolygonTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(exterior.getCoordinateN(0)));
        LineString interior = polygon.getInteriorRingN(0);
        MultiPolygonTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(interior.getCoordinateN(0)));
    }

    public void testEncode() throws Exception {
        MultiPolygon geometry = GML3MockData.multiPolygon();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiPolygon);
        MultiPolygonTypeBindingTest.assertEquals((String)"geometry", (String)this.getID(dom.getDocumentElement()));
        MultiPolygonTypeBindingTest.assertEquals((int)2, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "polygonMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Polygon.getLocalPart());
        MultiPolygonTypeBindingTest.assertEquals((int)2, (int)children.getLength());
        MultiPolygonTypeBindingTest.assertEquals((String)"geometry.1", (String)this.getID(children.item(0)));
        MultiPolygonTypeBindingTest.assertEquals((String)"geometry.2", (String)this.getID(children.item(1)));
    }
}

