/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.w3c.dom.Document;

public class MultiGeometryTypeBindingTest
extends GML3TestSupport {
    public void testParse() throws Exception {
        GML3MockData.multiGeometry(this.document, this.document);
        GeometryCollection multiGeom = (GeometryCollection)this.parse();
        MultiGeometryTypeBindingTest.assertNotNull((Object)multiGeom);
        MultiGeometryTypeBindingTest.assertEquals((int)3, (int)multiGeom.getNumGeometries());
    }

    public void testEncode() throws Exception {
        GeometryCollection geometry = GML3MockData.multiGeometry();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiGeometry);
        MultiGeometryTypeBindingTest.assertEquals((String)"geometry", (String)this.getID(dom.getDocumentElement()));
        MultiGeometryTypeBindingTest.assertEquals((int)3, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "geometryMember").getLength());
        MultiGeometryTypeBindingTest.assertEquals((String)"geometry.2", (String)this.getID(dom.getElementsByTagNameNS("http://www.opengis.net/gml", "LineString").item(0)));
        MultiGeometryTypeBindingTest.assertEquals((String)"geometry.3", (String)this.getID(dom.getElementsByTagNameNS("http://www.opengis.net/gml", "Polygon").item(0)));
    }
}

