/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class MultiCurveEncoderTest
extends GeometryEncoderTestSupport {
    public void testEncodeMultiCompound() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", true);
        Geometry geometry = new WKTReader2().read("MULTICURVE((100 100, 120 120), COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry);
        MultiCurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:MultiCurve", doc).getLength());
        MultiCurveEncoderTest.assertEquals((int)2, (int)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember", doc).getLength());
        MultiCurveEncoderTest.assertEquals((String)"100 100 120 120", (String)this.xpath.evaluate("//gml:MultiCurve/gml:curveMember[1]/gml:LineString/gml:posList", doc));
        MultiCurveEncoderTest.assertEquals((int)2, (int)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/*", doc).getLength());
        MultiCurveEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        MultiCurveEncoderTest.assertEquals((String)"0 0 2 0 2 1 2 3 4 3", (String)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
        MultiCurveEncoderTest.assertEquals((String)"linear", (String)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:LineStringSegment/@interpolation", doc));
        MultiCurveEncoderTest.assertEquals((String)"4 3 4 5 1 4 0 0", (String)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:LineStringSegment/gml:posList", doc));
    }

    public void testEncodeMultiCurve() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", true);
        Geometry geometry = new WKTReader2().read("MULTICURVE((105 105, 125 125), CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry);
        MultiCurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:MultiCurve", doc).getLength());
        MultiCurveEncoderTest.assertEquals((int)2, (int)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember", doc).getLength());
        MultiCurveEncoderTest.assertEquals((String)"105 105 125 125", (String)this.xpath.evaluate("//gml:MultiCurve/gml:curveMember[1]/gml:LineString/gml:posList", doc));
        MultiCurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/*", doc).getLength());
        MultiCurveEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        MultiCurveEncoderTest.assertEquals((String)"-10 0 -8 2 -6 0 -8 -2 -10 0", (String)this.xpath.evaluate("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
    }

    public void testEncodeMultiLineString() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        Geometry geometry = new WKTReader2().read("MULTILINESTRING((105 105, 125 125))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "multi");
        MultiCurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:MultiLineString", doc).getLength());
        MultiCurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:MultiLineString/gml:lineStringMember", doc).getLength());
        MultiCurveEncoderTest.assertEquals((String)"105 105 125 125", (String)this.xpath.evaluate("//gml:MultiLineString/gml:lineStringMember[1]/gml:LineString/gml:posList", doc));
        MultiCurveEncoderTest.assertEquals((String)"multi", (String)this.xpath.evaluate("/gml:MultiLineString/@gml:id", doc));
        MultiCurveEncoderTest.assertEquals((String)"multi.1", (String)this.xpath.evaluate("/gml:MultiLineString/gml:lineStringMember/gml:LineString/@gml:id", doc));
    }
}

