/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryCollectionEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.w3c.dom.Document;

public class GeometryCollectionEncoderTest
extends GeometryEncoderTestSupport {
    public void testGeometryCollectionEncoder() throws ParseException, Exception {
        GeometryCollectionEncoder gce = new GeometryCollectionEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("GEOMETRYCOLLECTION (LINESTRING (180 200, 160 180), POINT (19 19), POINT (20 10))");
        Document doc = this.encode((GeometryEncoder)gce, geometry, "feature.1");
        GeometryCollectionEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:LineString", doc).getLength());
        GeometryCollectionEncoderTest.assertEquals((int)2, (int)this.xpath.getMatchingNodes("//gml:Point", doc).getLength());
        GeometryCollectionEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:MultiGeometry", doc).getLength());
        GeometryCollectionEncoderTest.assertEquals((String)"180 200 160 180", (String)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember/gml:LineString/gml:posList", doc));
        GeometryCollectionEncoderTest.assertEquals((String)"19 19", (String)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember/gml:Point/gml:pos", doc));
        GeometryCollectionEncoderTest.assertEquals((String)"feature.1", (String)this.xpath.evaluate("//gml:MultiGeometry/@gml:id", doc));
        GeometryCollectionEncoderTest.assertEquals((String)"feature.1.1", (String)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember[1]/gml:LineString/@gml:id", doc));
        GeometryCollectionEncoderTest.assertEquals((String)"feature.1.2", (String)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember[2]/gml:Point/@gml:id", doc));
        GeometryCollectionEncoderTest.assertEquals((String)"feature.1.3", (String)this.xpath.evaluate("//gml:MultiGeometry/gml:geometryMember[3]/gml:Point/@gml:id", doc));
    }
}

