/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.test.XMLTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GML3TestSupport
extends XMLTestSupport {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.registerNamespaceMapping("gml", "http://www.opengis.net/gml");
    }

    protected Configuration createConfiguration() {
        return new GMLConfiguration(this.enableExtendedArcSurfaceSupport());
    }

    protected void checkPosOrdinates(Document doc, int expectedNumOrdinates) {
        this.checkOrdinates(doc, GML.pos.getLocalPart(), expectedNumOrdinates);
    }

    protected void checkPosListOrdinates(Document doc, int expectedNumOrdinates) {
        this.checkOrdinates(doc, GML.posList.getLocalPart(), expectedNumOrdinates);
    }

    private void checkOrdinates(Document doc, String ordTag, int expectedNumOrdinates) {
        NodeList nl = doc.getElementsByTagNameNS("http://www.opengis.net/gml", ordTag);
        Node posListNode = nl.item(0);
        Assert.assertEquals((long)1L, (long)posListNode.getChildNodes().getLength());
        String content = posListNode.getChildNodes().item(0).getNodeValue();
        String[] ord = content.split("\\s+");
        Assert.assertEquals((long)expectedNumOrdinates, (long)ord.length);
    }

    protected void checkDimension(Document doc, String tag, int expectedDim) {
        NodeList lsNL = doc.getElementsByTagNameNS("http://www.opengis.net/gml", tag);
        Node geomNode = lsNL.item(0);
        NamedNodeMap attrMap = geomNode.getAttributes();
        Node dimNode = attrMap.getNamedItem("srsDimension");
        Assert.assertNotNull((Object)dimNode);
        String dimStr = dimNode.getChildNodes().item(0).getNodeValue();
        int dim = Integer.parseInt(dimStr);
        Assert.assertEquals((long)dim, (long)expectedDim);
    }

    protected boolean enableExtendedArcSurfaceSupport() {
        return false;
    }

    protected String getID(Node node) {
        return node.getAttributes().getNamedItemNS("http://www.opengis.net/gml", GML.id.getLocalPart()).getNodeValue();
    }
}

