/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class ArcStringTypeBindingTest
extends GML3TestSupport {
    @Override
    protected boolean enableExtendedArcSurfaceSupport() {
        return true;
    }

    @Test
    public void testParse() throws Exception {
        GML3MockData.arcStringWithPosList(this.document, this.document);
        LineString lineString = (LineString)this.parse();
        Assert.assertTrue((boolean)(lineString instanceof CircularString));
        CircularString cs = (CircularString)lineString;
        double[] controlPoints = cs.getControlPoints();
        Assert.assertEquals((double)1.0, (double)controlPoints[0], (double)0.0);
        Assert.assertEquals((double)1.0, (double)controlPoints[1], (double)0.0);
        Assert.assertEquals((double)2.0, (double)controlPoints[2], (double)0.0);
        Assert.assertEquals((double)2.0, (double)controlPoints[3], (double)0.0);
        Assert.assertEquals((double)3.0, (double)controlPoints[4], (double)0.0);
        Assert.assertEquals((double)1.0, (double)controlPoints[5], (double)0.0);
        Assert.assertEquals((double)5.0, (double)controlPoints[6], (double)0.0);
        Assert.assertEquals((double)5.0, (double)controlPoints[7], (double)0.0);
        Assert.assertEquals((double)7.0, (double)controlPoints[8], (double)0.0);
        Assert.assertEquals((double)3.0, (double)controlPoints[9], (double)0.0);
    }

    @Test
    public void testEncodeSimple() throws Exception {
        LineString curve = new CurvedGeometryFactory(0.1).createCurvedGeometry((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 5.0, 5.0, 7.0, 3.0}));
        Document dom = this.encode(curve, GML.curveProperty);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String basePath = "/gml:curveProperty/gml:Curve/gml:segments/gml:ArcString";
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes(basePath + "[@interpolation='circularArc3Points']", dom).getLength());
        Assert.assertEquals((Object)"1 1 2 2 3 1 5 5 7 3", (Object)xpath.evaluate(basePath + "/gml:posList", dom));
    }

    @Test
    public void testEncodeCompound() throws Exception {
        CurvedGeometryFactory factory = new CurvedGeometryFactory(0.1);
        LineString curve = factory.createCurvedGeometry((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 5.0, 5.0, 7.0, 3.0}));
        LineString straight = factory.createLineString((CoordinateSequence)new LiteCoordinateSequence(new double[]{7.0, 3.0, 10.0, 15.0}));
        LineString compound = factory.createCurvedGeometry(new LineString[]{curve, straight});
        Document dom = this.encode(compound, GML.curveProperty);
        XpathEngine xpath = XMLUnit.newXpathEngine();
        String basePath1 = "/gml:curveProperty/gml:Curve/gml:segments/gml:ArcString";
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes(basePath1 + "[@interpolation='circularArc3Points']", dom).getLength());
        Assert.assertEquals((Object)"1 1 2 2 3 1 5 5 7 3", (Object)xpath.evaluate(basePath1 + "/gml:posList", dom));
        String basePath2 = "/gml:curveProperty/gml:Curve/gml:segments/gml:LineStringSegment";
        Assert.assertEquals((long)1L, (long)xpath.getMatchingNodes(basePath2 + "[@interpolation='linear']", dom).getLength());
        Assert.assertEquals((Object)"7 3 10 15", (Object)xpath.evaluate(basePath2 + "/gml:posList", dom));
    }
}

