/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.ComplexAttributeTestSupport;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.measure.Measure;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.ComplexAttribute;
import org.w3c.dom.Document;

public class MeasureTypeBindingTest
extends ComplexAttributeTestSupport {
    @Test
    public void testParser() throws Exception {
        GML3MockData.element(GML.measure, this.document, this.document);
        this.document.getDocumentElement().setAttribute("uom", "http://someuri");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1234"));
        Measure measure = (Measure)this.parse();
        Assert.assertNotNull((Object)measure);
        Assert.assertEquals((double)1234.0, (double)measure.doubleValue(), (double)0.1);
        Assert.assertEquals((Object)"http://someuri", (Object)measure.getUnit().getSymbol());
    }

    @Test
    public void testEncode() throws Exception {
        ComplexAttribute myCode = this.gmlMeasureType(GML.measure, "12", "m");
        Document dom = this.encode(myCode, GML.measure);
        Assert.assertEquals((Object)"gml:measure", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"12", (Object)dom.getDocumentElement().getFirstChild().getNodeValue());
        Assert.assertNotNull((Object)dom.getDocumentElement().getAttribute("uom"));
        Assert.assertEquals((Object)"m", (Object)dom.getDocumentElement().getAttribute("uom"));
    }
}

