/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class CurveEncoderTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeCircle() throws Exception {
        CurveEncoder encoder = new CurveEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        LineString geometry = (LineString)new WKTReader2().read("CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0)");
        Document doc = this.encode(encoder, geometry, "circle.abc");
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:Curve/gml:segments/gml:ArcString/gml:posList", doc).getLength());
        Assert.assertEquals((Object)"circularArc3Points", (Object)this.xpath.evaluate("//gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        Assert.assertEquals((Object)"-10 0 -8 2 -6 0 -8 -2 -10 0", (Object)this.xpath.evaluate("//gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
        Assert.assertEquals((Object)"circle.abc", (Object)this.xpath.evaluate("//gml:Curve/@gml:id", doc));
    }

    @Test
    public void testEncodeCompound() throws Exception {
        CurveEncoder encoder = new CurveEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        LineString geometry = (LineString)new WKTReader2().read("COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0))");
        Document doc = this.encode(encoder, geometry, "compound.3");
        Assert.assertEquals((long)2L, (long)this.xpath.getMatchingNodes("//gml:Curve//gml:segments/*", doc).getLength());
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:ArcString", doc).getLength());
        Assert.assertEquals((long)1L, (long)this.xpath.getMatchingNodes("//gml:LineStringSegment", doc).getLength());
        Assert.assertEquals((Object)"circularArc3Points", (Object)this.xpath.evaluate("//gml:ArcString/@interpolation", doc));
        Assert.assertEquals((Object)"0 0 2 0 2 1 2 3 4 3", (Object)this.xpath.evaluate("//gml:ArcString/gml:posList", doc));
        Assert.assertEquals((Object)"linear", (Object)this.xpath.evaluate("//gml:LineStringSegment/@interpolation", doc));
        Assert.assertEquals((Object)"4 3 4 5 1 4 0 0", (Object)this.xpath.evaluate("//gml:LineStringSegment/gml:posList", doc));
        Assert.assertEquals((Object)"compound.3", (Object)this.xpath.evaluate("//gml:Curve/@gml:id", doc));
    }
}

