/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPoint;
import org.w3c.dom.Document;

public class MultiPointTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeMultiPoint() throws Exception {
        MultiPointEncoder encoder = new MultiPointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        MultiPoint geometry = (MultiPoint)new WKTReader2().read("MULTIPOINT(0 0, 1 1)");
        Document doc = this.encode(encoder, geometry, "points");
        Assert.assertEquals((Object)"0 0", (Object)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[1]/gml:Point/gml:pos", doc));
        Assert.assertEquals((Object)"1 1", (Object)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[2]/gml:Point/gml:pos", doc));
        Assert.assertEquals((Object)"points", (Object)this.xpath.evaluate("/gml:MultiPoint/@gml:id", doc));
        Assert.assertEquals((Object)"points.1", (Object)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[1]/gml:Point/@gml:id", doc));
        Assert.assertEquals((Object)"points.2", (Object)this.xpath.evaluate("/gml:MultiPoint/gml:pointMember[2]/gml:Point/@gml:id", doc));
    }

    @Test
    public void testEncodeMultiPointNoGmlId() throws Exception {
        MultiPointEncoder encoder = new MultiPointEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        MultiPoint geometry = (MultiPoint)new WKTReader2().read("MULTIPOINT(0 0, 1 1)");
        Document doc = this.encode(encoder, geometry, "points");
        Assert.assertEquals((Object)"0", (Object)this.xpath.evaluate("count(//gml:MultiPoint/gml:pointMember/gml:Point/@gml:id)", doc));
    }
}

