/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiPolygonEncoder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.w3c.dom.Document;

public class MultiPolygonTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeMultiPolygon() throws Exception {
        MultiPolygonEncoder encoder = new MultiPolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        MultiPolygon geometry = (MultiPolygon)new WKTReader2().read("MULTIPOLYGON(((1 1,5 1,5 5,1 5,1 1),(2 2, 3 2, 3 3, 2 3,2 2)),((3 3,6 2,6 4,3 3)))");
        Document doc = this.encode(encoder, geometry, "mpoly");
        Assert.assertEquals((Object)"1 1 5 1 5 5 1 5 1 1", (Object)this.xpath.evaluate("/gml:MultiSurface/gml:surfaceMember[1]/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc));
        Assert.assertEquals((Object)"mpoly", (Object)this.xpath.evaluate("/gml:MultiSurface/@gml:id", doc));
        Assert.assertEquals((Object)"mpoly.1", (Object)this.xpath.evaluate("/gml:MultiSurface/gml:surfaceMember[1]/gml:Polygon/@gml:id", doc));
        Assert.assertEquals((Object)"mpoly.2", (Object)this.xpath.evaluate("/gml:MultiSurface/gml:surfaceMember[2]/gml:Polygon/@gml:id", doc));
    }

    @Test
    public void testEncodeMultiPolygonNoGmlId() throws Exception {
        MultiPolygonEncoder encoder = new MultiPolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        MultiPolygon geometry = (MultiPolygon)new WKTReader2().read("MULTIPOLYGON(((1 1,5 1,5 5,1 5,1 1),(2 2, 3 2, 3 3, 2 3,2 2)),((3 3,6 2,6 4,3 3)))");
        Document doc = this.encode(encoder, geometry, "mpoly");
        Assert.assertEquals((Object)"0", (Object)this.xpath.evaluate("count(/gml:MultiSurface/gml:surfaceMember/gml:Polygon/@gml:id)", doc));
    }
}

