/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.gml3.bindings.TEST;
import org.geotools.gml3.bindings.TestConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GML3EncodingTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("test", TEST.TestFeature.getNamespaceURI());
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    public void testEncodeFeatureWithBounds() throws Exception {
        SimpleFeature feature = GML3MockData.feature();
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        Document dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        GML3EncodingTest.assertEquals((int)1, (int)dom.getElementsByTagName("gml:boundedBy").getLength());
    }

    public void testEncodeFeatureWithNoBounds() throws Exception {
        SimpleFeature feature = GML3MockData.feature();
        TestConfiguration configuration = new TestConfiguration();
        configuration.getProperties().add(org.geotools.gml2.GMLConfiguration.NO_FEATURE_BOUNDS);
        Encoder encoder = new Encoder((Configuration)configuration);
        Document dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        GML3EncodingTest.assertEquals((int)0, (int)dom.getElementsByTagName("gml:boundedBy").getLength());
    }

    public void testEncodeWithNoSrsDimension() throws Exception {
        GMLConfiguration gml = new GMLConfiguration();
        Document dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        GML3EncodingTest.assertTrue((boolean)dom.getDocumentElement().hasAttribute("srsDimension"));
        gml.getProperties().add(GMLConfiguration.NO_SRS_DIMENSION);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        GML3EncodingTest.assertFalse((boolean)dom.getDocumentElement().hasAttribute("srsDimension"));
    }

    public void testEncodeSrsSyntax() throws Exception {
        GMLConfiguration gml = new GMLConfiguration();
        Document dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        GML3EncodingTest.assertTrue((boolean)dom.getDocumentElement().getAttribute("srsName").startsWith("urn:x-ogc:def:crs:EPSG:"));
        gml.setSrsSyntax(SrsSyntax.OGC_URN);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        GML3EncodingTest.assertTrue((boolean)dom.getDocumentElement().getAttribute("srsName").startsWith("urn:ogc:def:crs:EPSG::"));
        gml.setSrsSyntax(SrsSyntax.OGC_HTTP_URI);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        GML3EncodingTest.assertTrue((boolean)dom.getDocumentElement().getAttribute("srsName").startsWith("http://www.opengis.net/def/crs/EPSG/0/"));
    }

    public void testEncodeFeatureWithNullValues() throws Exception {
        SimpleFeatureType type = this.buildTestFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        builder.add((Object)"theName");
        builder.add((Object)"theDescription");
        builder.add((Object)GML3MockData.point());
        builder.add(null);
        builder.add(null);
        SimpleFeature feature = builder.buildFeature("fid.1");
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        Document dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        NodeList countList = dom.getElementsByTagName("test:count");
        Node count = countList.item(0);
        GML3EncodingTest.assertEquals((String)"true", (String)count.getAttributes().getNamedItem("xs:nil").getTextContent());
        NodeList dateList = dom.getElementsByTagName("test:date");
        Node date = dateList.item(0);
        GML3EncodingTest.assertEquals((String)"true", (String)date.getAttributes().getNamedItem("xs:nil").getTextContent());
        encoder = new Encoder((Configuration)configuration);
        encoder.getNamespaces().declarePrefix("xsd", "http://www.w3.org/2001/XMLSchema");
        dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        countList = dom.getElementsByTagName("test:count");
        count = countList.item(0);
        GML3EncodingTest.assertEquals((String)"true", (String)count.getAttributes().getNamedItem("xsd:nil").getTextContent());
        dateList = dom.getElementsByTagName("test:date");
        date = dateList.item(0);
        GML3EncodingTest.assertEquals((String)"true", (String)date.getAttributes().getNamedItem("xsd:nil").getTextContent());
    }

    private SimpleFeatureType buildTestFeatureType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(TEST.TestFeature.getLocalPart());
        typeBuilder.setNamespaceURI(TEST.TestFeature.getNamespaceURI());
        typeBuilder.add("name", String.class);
        typeBuilder.add("description", String.class);
        typeBuilder.add("geom", Point.class);
        typeBuilder.nillable(true);
        typeBuilder.add("count", Integer.class);
        typeBuilder.nillable(true);
        typeBuilder.add("date", Date.class);
        typeBuilder.add("data", String.class);
        typeBuilder.add("decimal", BigDecimal.class);
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        return type;
    }

    public void testEncodeBigDecimal() throws Exception {
        SimpleFeatureType type = this.buildTestFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        builder.add((Object)"theName");
        builder.add((Object)"theDescription");
        builder.add((Object)GML3MockData.point());
        builder.add(null);
        builder.add(null);
        builder.add(null);
        builder.add((Object)new BigDecimal("0.000000015"));
        SimpleFeature feature = builder.buildFeature("fid.1");
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        encoder.setIndentSize(2);
        String xml = encoder.encodeAsString((Object)feature, TEST.TestFeature);
        Document dom = XMLUnit.buildControlDocument((String)xml);
        XMLAssert.assertXpathEvaluatesTo((String)"0.000000015", (String)"//test:decimal", (Document)dom);
    }

    @Test
    public void testRemoveInvalidXMLChars() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)TEST.TestFeature.getNamespaceURI(), (String)TEST.TestFeature.getLocalPart(), (String)"the_geom:Point,data:String");
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{new WKTReader().read("POINT(0 0)"), "One \u0007 test"}, (String)"123");
        SimpleFeatureCollection fc = DataUtilities.collection((SimpleFeature)feature);
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        String result = encoder.encodeAsString((Object)feature, TEST.TestFeature);
        Document dom = XMLUnit.buildControlDocument((String)result);
        XMLAssert.assertXpathEvaluatesTo((String)"One  test", (String)"//test:data", (Document)dom);
    }
}

