/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.xsd.XSDSchema;
import org.geotools.gml3.GML;
import org.geotools.xsd.SchemaLocator;
import org.geotools.xsd.Schemas;
import org.junit.Test;

public class SchemasTest {
    @Test
    public void testConcurrentParse() throws Exception {
        URL location = SchemasTest.class.getResource("states.xsd");
        final File schemaFile = new File(location.toURI());
        final List<SchemaLocator> locators = Arrays.asList(GML.getInstance().createSchemaLocator());
        ExecutorService es = Executors.newFixedThreadPool(32);
        ArrayList<Future> results = new ArrayList<Future>();
        for (int i = 0; i < 128; ++i) {
            Future future = es.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    XSDSchema schema = Schemas.parse((String)schemaFile.getAbsolutePath(), (List)locators, null);
                    Schemas.dispose((XSDSchema)schema);
                    return null;
                }
            });
            results.add(future);
        }
        for (Future future : results) {
            future.get();
        }
    }
}

