/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.DirectPosition3D;
import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.opengis.geometry.DirectPosition;
import org.w3c.dom.Document;

public class DirectPositionListTypeBindingTest
extends GML3TestSupport {
    public void test1D() throws Exception {
        GML3MockData.element(GML.posList, this.document, this.document);
        this.document.getDocumentElement().setAttribute("srsDimension", "1");
        this.document.getDocumentElement().setAttribute("count", "2");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0 2.0 "));
        DirectPosition[] dps = (DirectPosition[])this.parse();
        DirectPositionListTypeBindingTest.assertNotNull((Object)dps);
        DirectPositionListTypeBindingTest.assertEquals((int)2, (int)dps.length);
        DirectPositionListTypeBindingTest.assertTrue((boolean)(dps[0] instanceof DirectPosition1D));
        DirectPositionListTypeBindingTest.assertTrue((boolean)(dps[1] instanceof DirectPosition1D));
        DirectPositionListTypeBindingTest.assertEquals((double)1.0, (double)dps[0].getOrdinate(0), (double)0.0);
        DirectPositionListTypeBindingTest.assertEquals((double)2.0, (double)dps[1].getOrdinate(0), (double)0.0);
    }

    public void test2D() throws Exception {
        GML3MockData.element(GML.posList, this.document, this.document);
        this.document.getDocumentElement().setAttribute("srsDimension", "2");
        this.document.getDocumentElement().setAttribute("count", "1");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0 2.0 "));
        DirectPosition[] dps = (DirectPosition[])this.parse();
        DirectPositionListTypeBindingTest.assertNotNull((Object)dps);
        DirectPositionListTypeBindingTest.assertEquals((int)1, (int)dps.length);
        DirectPositionListTypeBindingTest.assertTrue((boolean)(dps[0] instanceof DirectPosition2D));
        DirectPositionListTypeBindingTest.assertEquals((double)1.0, (double)dps[0].getOrdinate(0), (double)0.0);
        DirectPositionListTypeBindingTest.assertEquals((double)2.0, (double)dps[0].getOrdinate(1), (double)0.0);
    }

    public void test3D() throws Exception {
        GML3MockData.element(GML.posList, this.document, this.document);
        this.document.getDocumentElement().setAttribute("srsDimension", "3");
        this.document.getDocumentElement().appendChild(this.document.createTextNode("1.0 2.0 1.0 3 4 5"));
        DirectPosition[] dps = (DirectPosition[])this.parse();
        DirectPositionListTypeBindingTest.assertNotNull((Object)dps);
        DirectPositionListTypeBindingTest.assertEquals((int)2, (int)dps.length);
        DirectPositionListTypeBindingTest.assertTrue((boolean)(dps[0] instanceof DirectPosition3D));
        DirectPositionListTypeBindingTest.assertEquals((double)1.0, (double)dps[0].getOrdinate(0), (double)0.0);
        DirectPositionListTypeBindingTest.assertEquals((double)2.0, (double)dps[0].getOrdinate(1), (double)0.0);
        DirectPositionListTypeBindingTest.assertEquals((double)1.0, (double)dps[0].getOrdinate(2), (double)0.0);
        DirectPositionListTypeBindingTest.assertEquals((double)3.0, (double)dps[1].getOrdinate(0), (double)0.0);
        DirectPositionListTypeBindingTest.assertEquals((double)4.0, (double)dps[1].getOrdinate(1), (double)0.0);
        DirectPositionListTypeBindingTest.assertEquals((double)5.0, (double)dps[1].getOrdinate(2), (double)0.0);
    }

    public void testEncode2D() throws Exception {
        LineString line = GML3MockData.lineStringLite2D();
        CoordinateSequence seq = line.getCoordinateSequence();
        Document doc = this.encode(seq, GML.posList);
        this.checkPosListOrdinates(doc, 2 * line.getNumPoints());
    }

    public void testEncode3D() throws Exception {
        LineString line = GML3MockData.lineStringLite3D();
        CoordinateSequence seq = line.getCoordinateSequence();
        Document doc = this.encode(seq, GML.posList);
        this.checkPosListOrdinates(doc, 3 * line.getNumPoints());
    }
}

