/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Envelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvelopeTypeBindingTest
extends GML3TestSupport {
    public void testEncode() throws Exception {
        Document dom = this.encode(GML3MockData.bounds(), GML.Envelope);
        EnvelopeTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "lowerCorner").getLength());
        EnvelopeTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "upperCorner").getLength());
        Element lowerCorner = (Element)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "lowerCorner").item(0);
        EnvelopeTypeBindingTest.assertEquals((String)"0 0", (String)lowerCorner.getFirstChild().getNodeValue());
        Element upperCorner = (Element)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "upperCorner").item(0);
        EnvelopeTypeBindingTest.assertEquals((String)"10 10", (String)upperCorner.getFirstChild().getNodeValue());
        EnvelopeTypeBindingTest.assertEquals((String)"urn:x-ogc:def:crs:EPSG:4326", (String)dom.getDocumentElement().getAttributeNS(null, "srsName"));
    }

    public void testEncodeNull() throws Exception {
        Envelope e = new Envelope();
        e.setToNull();
        Document dom = this.encode(e, GML.Envelope);
        EnvelopeTypeBindingTest.assertEquals((int)1, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Null.getLocalPart()).getLength());
    }
}

