/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiLineString;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiCurveTypeBindingTest
extends GML3TestSupport {
    public void testEncode() throws Exception {
        MultiLineString geometry = GML3MockData.multiLineString();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiCurve);
        MultiCurveTypeBindingTest.assertEquals((String)"geometry", (String)this.getID(dom.getDocumentElement()));
        MultiCurveTypeBindingTest.assertEquals((int)2, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "curveMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.LineString.getLocalPart());
        MultiCurveTypeBindingTest.assertEquals((int)2, (int)children.getLength());
        MultiCurveTypeBindingTest.assertEquals((String)"geometry.1", (String)this.getID(children.item(0)));
        MultiCurveTypeBindingTest.assertEquals((String)"geometry.2", (String)this.getID(children.item(1)));
    }

    public void testParseWithCurveMember() throws Exception {
        GML3MockData.multiCurve(this.document, this.document);
        MultiLineString mline = (MultiLineString)this.parse();
        MultiCurveTypeBindingTest.assertEquals((int)2, (int)mline.getNumGeometries());
    }

    public void testParseWithCurveMembers() throws Exception {
        GML3MockData.multiCurve(this.document, this.document, false);
        MultiLineString mline = (MultiLineString)this.parse();
        MultiCurveTypeBindingTest.assertEquals((int)2, (int)mline.getNumGeometries());
    }
}

