/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MultiLineStringTypeBindingTest
extends GML3TestSupport {
    public void test() throws Exception {
        GML3MockData.multiLineString(this.document, this.document);
        MultiLineString multiLineString = (MultiLineString)this.parse();
        MultiLineStringTypeBindingTest.assertNotNull((Object)multiLineString);
        MultiLineStringTypeBindingTest.assertEquals((int)2, (int)multiLineString.getNumGeometries());
    }

    public void test3D() throws Exception {
        GML3MockData.multiLineString3D(this.document, this.document);
        MultiLineString multiLineString = (MultiLineString)this.parse();
        MultiLineStringTypeBindingTest.assertNotNull((Object)multiLineString);
        MultiLineStringTypeBindingTest.assertEquals((int)2, (int)multiLineString.getNumGeometries());
        LineString line = (LineString)multiLineString.getGeometryN(0);
        MultiLineStringTypeBindingTest.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        MultiLineStringTypeBindingTest.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
    }

    public void testEncode() throws Exception {
        MultiLineString geometry = GML3MockData.multiLineString();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiLineString);
        MultiLineStringTypeBindingTest.assertEquals((String)"geometry", (String)this.getID(dom.getDocumentElement()));
        MultiLineStringTypeBindingTest.assertEquals((int)2, (int)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "lineStringMember").getLength());
        NodeList children = dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.LineString.getLocalPart());
        MultiLineStringTypeBindingTest.assertEquals((int)2, (int)children.getLength());
        MultiLineStringTypeBindingTest.assertEquals((String)"geometry.1", (String)this.getID(children.item(0)));
        MultiLineStringTypeBindingTest.assertEquals((String)"geometry.2", (String)this.getID(children.item(1)));
        this.checkDimension(dom, GML.MultiLineString.getLocalPart(), 2);
        this.checkDimension(dom, GML.LineString.getLocalPart(), 2);
        this.checkPosListOrdinates(dom, 2 * geometry.getGeometryN(0).getNumPoints());
    }
}

