/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class CurveEncoderTest
extends GeometryEncoderTestSupport {
    public void testEncodeCircle() throws Exception {
        CurveEncoder encoder = new CurveEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0)");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "circle.abc");
        CurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:Curve/gml:segments/gml:ArcString/gml:posList", doc).getLength());
        CurveEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate("//gml:Curve/gml:segments/gml:ArcString/@interpolation", doc));
        CurveEncoderTest.assertEquals((String)"-10 0 -8 2 -6 0 -8 -2 -10 0", (String)this.xpath.evaluate("//gml:Curve/gml:segments/gml:ArcString/gml:posList", doc));
        CurveEncoderTest.assertEquals((String)"circle.abc", (String)this.xpath.evaluate("//gml:Curve/@gml:id", doc));
    }

    public void testEncodeCompound() throws Exception {
        CurveEncoder encoder = new CurveEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0))");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "compound.3");
        CurveEncoderTest.assertEquals((int)2, (int)this.xpath.getMatchingNodes("//gml:Curve//gml:segments/*", doc).getLength());
        CurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:ArcString", doc).getLength());
        CurveEncoderTest.assertEquals((int)1, (int)this.xpath.getMatchingNodes("//gml:LineStringSegment", doc).getLength());
        CurveEncoderTest.assertEquals((String)"circularArc3Points", (String)this.xpath.evaluate("//gml:ArcString/@interpolation", doc));
        CurveEncoderTest.assertEquals((String)"0 0 2 0 2 1 2 3 4 3", (String)this.xpath.evaluate("//gml:ArcString/gml:posList", doc));
        CurveEncoderTest.assertEquals((String)"linear", (String)this.xpath.evaluate("//gml:LineStringSegment/@interpolation", doc));
        CurveEncoderTest.assertEquals((String)"4 3 4 5 1 4 0 0", (String)this.xpath.evaluate("//gml:LineStringSegment/gml:posList", doc));
        CurveEncoderTest.assertEquals((String)"compound.3", (String)this.xpath.evaluate("//gml:Curve/@gml:id", doc));
    }
}

