/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.LineStringEncoder;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.w3c.dom.Document;

public class LineString3DTest
extends GeometryEncoderTestSupport {
    public void testEncode3DLine() throws Exception {
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Geometry geometry = new WKTReader2().read("LINESTRING(0 0 50, 120 0 100)");
        Document doc = this.encode((GeometryEncoder)encoder, geometry, "threed");
        LineString3DTest.assertEquals((String)"0 0 50 120 0 100", (String)this.xpath.evaluate("//gml:posList", doc));
        LineString3DTest.assertEquals((String)"threed", (String)this.xpath.evaluate("//gml:LineString/@gml:id", doc));
    }

    public void testEncode3DLineFromLiteCS() throws Exception {
        LineStringEncoder encoder = new LineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        LiteCoordinateSequence cs = new LiteCoordinateSequence(new double[]{0.0, 0.0, 50.0, 120.0, 0.0, 100.0}, 3);
        LineString geometry = new GeometryFactory().createLineString((CoordinateSequence)cs);
        Document doc = this.encode((GeometryEncoder)encoder, (Geometry)geometry);
        LineString3DTest.assertEquals((String)"0 0 50 120 0 100", (String)this.xpath.evaluate("//gml:posList", doc));
    }
}

