/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.v3_2.bindings;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.GML32TestSupport;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BoundingShapeTypeBindingTest
extends GML32TestSupport {
    public void testEncode() throws Exception {
        Envelope e = new Envelope(-180.0, -90.0, 180.0, 90.0);
        Document dom = this.encode(e, GML.boundedBy);
        BoundingShapeTypeBindingTest.assertEquals((String)"gml:Envelope", (String)dom.getDocumentElement().getFirstChild().getNodeName());
    }

    public void testEncodeWithCRS() throws Exception {
        ReferencedEnvelope e = new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, CRS.decode((String)"EPSG:4326"));
        Document dom = this.encode(e, GML.boundedBy);
        BoundingShapeTypeBindingTest.assertEquals((String)"gml:Envelope", (String)dom.getDocumentElement().getFirstChild().getNodeName());
        BoundingShapeTypeBindingTest.assertTrue((boolean)((Element)dom.getDocumentElement().getFirstChild()).getAttribute("srsName").endsWith("4326"));
    }

    public void testEncodeAsNull() throws Exception {
        Envelope e = new Envelope();
        e.setToNull();
        Document dom = this.encode(e, GML.boundedBy);
        BoundingShapeTypeBindingTest.assertEquals((String)"gml:Null", (String)dom.getDocumentElement().getFirstChild().getNodeName());
    }
}

