/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.gml3.bindings.TEST;
import org.geotools.gml3.bindings.TestConfiguration;
import org.geotools.xsd.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AbstractFeatureTypeBindingTest
extends GML3TestSupport {
    @Override
    protected Configuration createConfiguration() {
        return new TestConfiguration();
    }

    @Override
    protected Map<String, String> getNamespaces() {
        Map<String, String> namespaces = super.getNamespaces();
        namespaces.put("test", TEST.NAMESPACE);
        return namespaces;
    }

    @Test
    public void testWithoutGmlProperties() throws Exception {
        Element feature = GML3MockData.feature(this.document, this.document);
        feature.setAttributeNS("http://www.opengis.net/gml", "id", "fid.1");
        SimpleFeature f = (SimpleFeature)this.parse();
        Assert.assertNotNull((Object)feature);
        Assert.assertEquals((Object)"fid.1", (Object)f.getID());
        Point p = (Point)f.getDefaultGeometry();
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((double)1.0, (double)p.getX(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)p.getY(), (double)0.0);
        Integer i = (Integer)f.getAttribute("count");
        Assert.assertNotNull((Object)i);
        Assert.assertEquals((long)1L, (long)i.intValue());
    }

    @Test
    public void testEncode() throws Exception {
        Document dom = this.encode(GML3MockData.feature(), TEST.TestFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:boundedBy").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("test:geom").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("test:count").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("test:date").getLength());
    }
}

