/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.w3c.dom.Document;

public class MultiGeometryTypeBindingTest
extends GML3TestSupport {
    @Test
    public void testParse() throws Exception {
        GML3MockData.multiGeometry(this.document, this.document);
        GeometryCollection multiGeom = (GeometryCollection)this.parse();
        Assert.assertNotNull((Object)multiGeom);
        Assert.assertEquals((long)3L, (long)multiGeom.getNumGeometries());
    }

    @Test
    public void testEncode() throws Exception {
        GeometryCollection geometry = GML3MockData.multiGeometry();
        GML3EncodingUtils.setID((Geometry)geometry, (String)"geometry");
        Document dom = this.encode(geometry, GML.MultiGeometry);
        Assert.assertEquals((Object)"geometry", (Object)this.getID(dom.getDocumentElement()));
        Assert.assertEquals((long)3L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "geometryMember").getLength());
        Assert.assertEquals((Object)"geometry.2", (Object)this.getID(dom.getElementsByTagNameNS("http://www.opengis.net/gml", "LineString").item(0)));
        Assert.assertEquals((Object)"geometry.3", (Object)this.getID(dom.getElementsByTagNameNS("http://www.opengis.net/gml", "Polygon").item(0)));
    }
}

