/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryCollectionEncoder;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.io.ParseException;
import org.w3c.dom.Document;

public class GeometryCollectionEncoderTest
extends GeometryEncoderTestSupport {
    @Test
    public void testGeometryCollectionEncoder() throws ParseException, Exception {
        GeometryCollectionEncoder gce = new GeometryCollectionEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        GeometryCollection geometry = (GeometryCollection)new WKTReader2().read("GEOMETRYCOLLECTION (LINESTRING (180 200, 160 180), POINT (19 19), POINT (20 10))");
        Document doc = this.encode(gce, geometry, "feature.1");
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:LineString)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Point)", CoreMatchers.equalTo((Object)"2")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiGeometry)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiGeometry/gml:geometryMember/gml:LineString/gml:posList", CoreMatchers.equalTo((Object)"180 200 160 180")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiGeometry/gml:geometryMember/gml:Point/gml:pos", CoreMatchers.equalTo((Object)"19 19")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiGeometry/@gml:id", CoreMatchers.equalTo((Object)"feature.1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiGeometry/gml:geometryMember[1]/gml:LineString/@gml:id", CoreMatchers.equalTo((Object)"feature.1.1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiGeometry/gml:geometryMember[2]/gml:Point/@gml:id", CoreMatchers.equalTo((Object)"feature.1.2")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiGeometry/gml:geometryMember[3]/gml:Point/@gml:id", CoreMatchers.equalTo((Object)"feature.1.3")));
    }
}

