/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.util.Map;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.test.xml.XmlTestSupport;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.test.XMLTestSupport;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GML3TestSupport
extends XMLTestSupport {
    protected Map<String, String> getNamespaces() {
        return GML3TestSupport.namespaces((XmlTestSupport.Namespace[])new XmlTestSupport.Namespace[]{GML3TestSupport.Namespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema"), GML3TestSupport.Namespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema"), GML3TestSupport.Namespace((String)"gml", (String)"http://www.opengis.net/gml"), GML3TestSupport.Namespace((String)"xlink", (String)"http://www.w3.org/1999/xlink"), GML3TestSupport.Namespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance")});
    }

    protected Configuration createConfiguration() {
        return new GMLConfiguration(this.enableExtendedArcSurfaceSupport());
    }

    protected void checkPosOrdinates(Document doc, int expectedNumOrdinates) {
        this.checkOrdinates(doc, GML.pos.getLocalPart(), expectedNumOrdinates);
    }

    protected void checkPosListOrdinates(Document doc, int expectedNumOrdinates) {
        this.checkOrdinates(doc, GML.posList.getLocalPart(), expectedNumOrdinates);
    }

    private void checkOrdinates(Document doc, String ordTag, int expectedNumOrdinates) {
        NodeList nl = doc.getElementsByTagNameNS("http://www.opengis.net/gml", ordTag);
        Node posListNode = nl.item(0);
        Assert.assertEquals((long)1L, (long)posListNode.getChildNodes().getLength());
        String content = posListNode.getChildNodes().item(0).getNodeValue();
        String[] ord = content.split("\\s+");
        Assert.assertEquals((long)expectedNumOrdinates, (long)ord.length);
    }

    protected void checkDimension(Document doc, String tag, int expectedDim) {
        NodeList lsNL = doc.getElementsByTagNameNS("http://www.opengis.net/gml", tag);
        Node geomNode = lsNL.item(0);
        NamedNodeMap attrMap = geomNode.getAttributes();
        Node dimNode = attrMap.getNamedItem("srsDimension");
        Assert.assertNotNull((Object)dimNode);
        String dimStr = dimNode.getChildNodes().item(0).getNodeValue();
        int dim = Integer.parseInt(dimStr);
        Assert.assertEquals((long)dim, (long)expectedDim);
    }

    protected boolean enableExtendedArcSurfaceSupport() {
        return false;
    }

    protected String getID(Node node) {
        return node.getAttributes().getNamedItemNS("http://www.opengis.net/gml", GML.id.getLocalPart()).getNodeValue();
    }
}

