/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.data.DataTestCase;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.gml3.bindings.DelayedSchemaFeatureCollection;
import org.junit.Assert;
import org.junit.Test;

public class DelayedSchemaFeatureCollectionTest
extends DataTestCase {
    @Test
    public void testEmpty() {
        DelayedSchemaFeatureCollection fc = new DelayedSchemaFeatureCollection();
        Assert.assertEquals((Object)DelayedSchemaFeatureCollection.PLACEHOLDER, (Object)fc.getSchema());
        Assert.assertTrue((boolean)fc.getBounds().isEmpty());
        fc.add(this.riverFeatures[0]);
        Assert.assertFalse((boolean)fc.getBounds().isEmpty());
        Assert.assertEquals((Object)this.riverType, (Object)fc.getSchema());
    }

    @Test
    public void testTwoTypes() {
        DelayedSchemaFeatureCollection fc = new DelayedSchemaFeatureCollection();
        fc.add(this.riverFeatures[0]);
        fc.add(this.lakeFeatures[0]);
        Assert.assertEquals((Object)this.riverType, (Object)fc.getSchema());
        try (SimpleFeatureIterator it = fc.features();){
            Assert.assertEquals((Object)this.riverFeatures[0], (Object)it.next());
            Assert.assertEquals((Object)this.lakeFeatures[0], (Object)it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
    }
}

