/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LinearRing;

public class LinearRingTypeBindingTest
extends GML3TestSupport {
    @Test
    public void testPos() throws Exception {
        this.document.appendChild(GML3MockData.linearRingWithPos(this.document, null));
        LinearRing line = (LinearRing)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(0).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(3.0, 4.0), (Object)line.getPointN(1).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(5.0, 6.0), (Object)line.getPointN(2).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(3).getCoordinate());
    }

    @Test
    public void testPosList() throws Exception {
        this.document.appendChild(GML3MockData.linearRingWithPosList(this.document, null));
        LinearRing line = (LinearRing)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(0).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(3.0, 4.0), (Object)line.getPointN(1).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(5.0, 6.0), (Object)line.getPointN(2).getCoordinate());
        Assert.assertEquals((Object)new Coordinate(1.0, 2.0), (Object)line.getPointN(3).getCoordinate());
    }

    @Test
    public void testPos3D() throws Exception {
        this.document.appendChild(GML3MockData.linearRingWithPos3D(this.document, null, true));
        LinearRing line = (LinearRing)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(5.0, 6.0, 30.0).equals3D(line.getPointN(2).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(3).getCoordinate()));
    }

    @Test
    public void testPosList3D() throws Exception {
        this.document.appendChild(GML3MockData.linearRingWithPosList3D(this.document, null, true));
        LinearRing line = (LinearRing)this.parse();
        Assert.assertNotNull((Object)line);
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(0).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(3.0, 4.0, 20.0).equals3D(line.getPointN(1).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(5.0, 6.0, 30.0).equals3D(line.getPointN(2).getCoordinate()));
        Assert.assertTrue((boolean)new Coordinate(1.0, 2.0, 10.0).equals3D(line.getPointN(3).getCoordinate()));
    }
}

