/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.v3_2.bindings;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.GMLConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.XSD;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class GML32EncodingUtilsTest {
    @Test
    public void testGeometriesGML32FeatureEncoding() throws Exception {
        GMLConfiguration configuration = new GMLConfiguration();
        SchemaIndex index = Schemas.findSchemas((Configuration)configuration);
        SimpleFeatureType featureType = DataUtilities.createType((String)"feature", (String)"geometry1:LineString,geometry2:MultiLineString,geometry3:Polygon,geometry4:MultiPolygon,geometry5:Point,geometry6:MultiPoint");
        GMLEncodingUtils encoder = new GMLEncodingUtils((XSD)GML.getInstance());
        XSDTypeDefinition type = encoder.createXmlTypeFromFeatureType(featureType, index, Collections.emptySet());
        List elements = Schemas.getChildElementDeclarations((XSDTypeDefinition)type, (boolean)false);
        MatcherAssert.assertThat((Object)elements, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)elements.size(), (Matcher)CoreMatchers.is((Object)6));
        List typesNames = elements.stream().map(XSDFeature::getType).filter(elementType -> elementType != null).map(XSDNamedComponent::getName).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)typesNames.size(), (Matcher)CoreMatchers.is((Object)6));
        MatcherAssert.assertThat(typesNames, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"CurvePropertyType", "MultiCurvePropertyType", "SurfacePropertyType", "MultiSurfacePropertyType", "PointPropertyType", "MultiPointPropertyType"}));
    }
}

