/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.Position1D;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.Position3D;
import org.geotools.gml.producer.CoordinateFormatter;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionTypeBinding
extends AbstractComplexBinding {
    GeometryFactory factory;
    CoordinateFormatter formatter;

    public DirectPositionTypeBinding(GeometryFactory factory) {
        this.factory = factory;
    }

    public DirectPositionTypeBinding(GeometryFactory factory, CoordinateFormatter formatter) {
        this.factory = factory;
        this.formatter = formatter;
    }

    public QName getTarget() {
        return GML.DirectPositionType;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return CoordinateSequence.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        Double[] position = (Double[])value;
        Position1D dp = null;
        if (position.length < 2) {
            dp = crs != null ? new Position1D(crs) : new Position1D();
            dp.setOrdinate(0, position[0].doubleValue());
        } else if (position.length < 3) {
            dp = crs != null ? new Position2D(crs) : new Position2D();
            dp.setOrdinate(0, position[0].doubleValue());
            dp.setOrdinate(1, position[1].doubleValue());
        } else {
            dp = crs != null ? new Position3D(crs) : new Position3D();
            dp.setOrdinate(0, position[0].doubleValue());
            dp.setOrdinate(1, position[1].doubleValue());
            dp.setOrdinate(2, position[2].doubleValue());
        }
        return dp;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        CoordinateSequence cs = (CoordinateSequence)object;
        boolean hasm = cs.hasM();
        StringBuffer sb = new StringBuffer();
        if (cs.size() >= 1) {
            int dim = cs.getDimension();
            for (int d = 0; d < dim; ++d) {
                double v = cs.getOrdinate(0, d);
                if (hasm && dim == 3 && d == 2) {
                    this.formatAndAppend(sb, 0.0);
                }
                if (Double.isNaN(v) && d > 1) continue;
                this.formatAndAppend(sb, v);
            }
            if (dim > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return value;
    }

    private void formatAndAppend(StringBuffer sb, double v) {
        if (this.formatter != null) {
            this.formatter.format(v, sb);
        } else {
            sb.append(String.valueOf(v));
        }
        sb.append(" ");
    }
}

