/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import org.geotools.gml3.GML;
import org.geotools.gml3.GML3TestSupport;
import org.geotools.gml3.bindings.GML3MockData;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvelopeTypeBindingTest
extends GML3TestSupport {
    @Test
    public void testEncode() throws Exception {
        Document dom = this.encode(GML3MockData.bounds(), GML.Envelope);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "lowerCorner").getLength());
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "upperCorner").getLength());
        Element lowerCorner = (Element)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "lowerCorner").item(0);
        Assert.assertEquals((Object)"0 0", (Object)lowerCorner.getFirstChild().getNodeValue());
        Element upperCorner = (Element)dom.getElementsByTagNameNS("http://www.opengis.net/gml", "upperCorner").item(0);
        Assert.assertEquals((Object)"10 10", (Object)upperCorner.getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"urn:x-ogc:def:crs:EPSG:4326", (Object)dom.getDocumentElement().getAttributeNS(null, "srsName"));
    }

    @Test
    public void testEncodeNull() throws Exception {
        Envelope e = new Envelope();
        e.setToNull();
        Document dom = this.encode(e, GML.Envelope);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Null.getLocalPart()).getLength());
    }
}

