/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;

public class MultiCurveEncoderTest
extends GeometryEncoderTestSupport {
    @Test
    public void testEncodeMultiCompound() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", true);
        Geometry geometry = new WKTReader2().read("MULTICURVE((100 100, 120 120), COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)))");
        Document doc = this.encode(encoder, geometry);
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiCurve)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiCurve/gml:curveMember)", CoreMatchers.equalTo((Object)"2")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiCurve/gml:curveMember[1]/gml:LineString/gml:posList", CoreMatchers.equalTo((Object)"100 100 120 120")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/*)", CoreMatchers.equalTo((Object)"2")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"0 0 2 0 2 1 2 3 4 3")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:LineStringSegment/@interpolation", CoreMatchers.equalTo((Object)"linear")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:LineStringSegment/gml:posList", CoreMatchers.equalTo((Object)"4 3 4 5 1 4 0 0")));
    }

    @Test
    public void testEncodeMultiCurve() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", true);
        Geometry geometry = new WKTReader2().read("MULTICURVE((105 105, 125 125), CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0))");
        Document doc = this.encode(encoder, geometry);
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiCurve)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiCurve/gml:curveMember)", CoreMatchers.equalTo((Object)"2")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiCurve/gml:curveMember[1]/gml:LineString/gml:posList", CoreMatchers.equalTo((Object)"105 105 125 125")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/*)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiCurve/gml:curveMember[2]/gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"-10 0 -8 2 -6 0 -8 -2 -10 0")));
    }

    @Test
    public void testEncodeMultiLineString() throws Exception {
        MultiLineStringEncoder encoder = new MultiLineStringEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml", false);
        Geometry geometry = new WKTReader2().read("MULTILINESTRING((105 105, 125 125))");
        Document doc = this.encode(encoder, geometry, "multi");
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiLineString)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:MultiLineString/gml:lineStringMember)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("//gml:MultiLineString/gml:lineStringMember[1]/gml:LineString/gml:posList", CoreMatchers.equalTo((Object)"105 105 125 125")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiLineString/@gml:id", CoreMatchers.equalTo((Object)"multi")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("/gml:MultiLineString/gml:lineStringMember/gml:LineString/@gml:id", CoreMatchers.equalTo((Object)"multi.1")));
    }
}

