/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.gml3.v3_2.gsr;

import java.util.Set;
import javax.xml.namespace.QName;
import org.geotools.api.feature.type.Schema;
import org.geotools.gml3.v3_2.GML;
import org.geotools.gml3.v3_2.gco.GCO;
import org.geotools.xsd.XSD;

/**
 * This interface contains the qualified names of all the types,elements, and attributes in the
 * http://www.isotc211.org/2005/gsr schema.
 *
 * @generated
 */
public final class GSR extends GML.DelegatingXSD {

    /** singleton instance */
    private static final GSR instance = new GSR();

    /** Returns the singleton instance. */
    public static final GSR getInstance() {
        return instance;
    }

    /** private constructor */
    private GSR() {}

    @Override
    protected void addDependencies(Set<XSD> dependencies) {
        dependencies.add(GCO.getInstance());
    }

    @Override
    protected Schema buildTypeSchema() {
        return new GSRSchema();
    }

    /** Returns 'http://www.isotc211.org/2005/gsr'. */
    @Override
    public String getNamespaceURI() {
        return NAMESPACE;
    }

    /** Returns the location of 'gsr.xsd.'. */
    @Override
    public String getSchemaLocation() {
        return getClass().getResource("gsr.xsd").toString();
    }

    /** @generated */
    public static final String NAMESPACE = "http://www.isotc211.org/2005/gsr";

    /* Type Definitions */
    /** @generated */
    public static final QName SC_CRS_PropertyType =
            new QName("http://www.isotc211.org/2005/gsr", "SC_CRS_PropertyType");

    /* Elements */

    /* Attributes */

}
