/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.GML3MockData;
import org.geotools.gml3.bindings.TEST;
import org.geotools.gml3.bindings.TestConfiguration;
import org.geotools.referencing.CRS;
import org.geotools.test.xml.XmlTestSupport;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class GML3EncodingTest
extends XmlTestSupport {
    protected Map<String, String> getNamespaces() {
        return GML3EncodingTest.namespaces((XmlTestSupport.Namespace[])new XmlTestSupport.Namespace[]{GML3EncodingTest.Namespace((String)"test", (String)TEST.TestFeature.getNamespaceURI())});
    }

    @Test
    public void testEncodeFeatureWithBounds() throws Exception {
        SimpleFeature feature = GML3MockData.feature();
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        Document dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("gml:boundedBy").getLength());
    }

    @Test
    public void testEncodeFeatureWithNoBounds() throws Exception {
        SimpleFeature feature = GML3MockData.feature();
        TestConfiguration configuration = new TestConfiguration();
        configuration.getProperties().add(org.geotools.gml2.GMLConfiguration.NO_FEATURE_BOUNDS);
        Encoder encoder = new Encoder((Configuration)configuration);
        Document dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("gml:boundedBy").getLength());
    }

    @Test
    public void testEncodeWithNoSrsDimension() throws Exception {
        GMLConfiguration gml = new GMLConfiguration();
        Document dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        Assert.assertTrue((boolean)dom.getDocumentElement().hasAttribute("srsDimension"));
        gml.getProperties().add(GMLConfiguration.NO_SRS_DIMENSION);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        Assert.assertFalse((boolean)dom.getDocumentElement().hasAttribute("srsDimension"));
    }

    @Test
    public void testEncodeSrsSyntax() throws Exception {
        GMLConfiguration gml = new GMLConfiguration();
        Document dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        Assert.assertTrue((boolean)dom.getDocumentElement().getAttribute("srsName").startsWith("urn:x-ogc:def:crs:EPSG:"));
        gml.setSrsSyntax(SrsSyntax.OGC_URN);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        Assert.assertTrue((boolean)dom.getDocumentElement().getAttribute("srsName").startsWith("urn:ogc:def:crs:EPSG::"));
        gml.setSrsSyntax(SrsSyntax.OGC_HTTP_URI);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)GML3MockData.point(), GML.Point);
        Assert.assertTrue((boolean)dom.getDocumentElement().getAttribute("srsName").startsWith("http://www.opengis.net/def/crs/EPSG/0/"));
    }

    @Test
    public void testEncodeSrsSyntaxIAU() throws Exception {
        Point p = new GeometryFactory().createPoint(new Coordinate(1.0, 2.0));
        p.setUserData((Object)CRS.decode((String)"urn:x-ogc:def:crs:IAU::1000"));
        GMLConfiguration gml = new GMLConfiguration();
        Document dom = new Encoder((Configuration)gml).encodeAsDOM((Object)p, GML.Point);
        Assert.assertEquals((Object)"urn:x-ogc:def:crs:IAU:1000", (Object)dom.getDocumentElement().getAttribute("srsName"));
        gml.setSrsSyntax(SrsSyntax.OGC_URN);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)p, GML.Point);
        Assert.assertEquals((Object)"urn:ogc:def:crs:IAU::1000", (Object)dom.getDocumentElement().getAttribute("srsName"));
        gml.setSrsSyntax(SrsSyntax.OGC_HTTP_URI);
        dom = new Encoder((Configuration)gml).encodeAsDOM((Object)p, GML.Point);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/IAU/0/1000", (Object)dom.getDocumentElement().getAttribute("srsName"));
    }

    @Test
    public void testEncodeFeatureWithNullValues() throws Exception {
        SimpleFeatureType type = this.buildTestFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        builder.add((Object)"theName");
        builder.add((Object)"theDescription");
        builder.add((Object)GML3MockData.point());
        builder.add(null);
        builder.add(null);
        SimpleFeature feature = builder.buildFeature("fid.1");
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        Document dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        NodeList countList = dom.getElementsByTagName("test:count");
        Node count = countList.item(0);
        Assert.assertEquals((Object)"true", (Object)count.getAttributes().getNamedItem("xs:nil").getTextContent());
        NodeList dateList = dom.getElementsByTagName("test:date");
        Node date = dateList.item(0);
        Assert.assertEquals((Object)"true", (Object)date.getAttributes().getNamedItem("xs:nil").getTextContent());
        encoder = new Encoder((Configuration)configuration);
        encoder.getNamespaces().declarePrefix("xsd", "http://www.w3.org/2001/XMLSchema");
        dom = encoder.encodeAsDOM((Object)feature, TEST.TestFeature);
        countList = dom.getElementsByTagName("test:count");
        count = countList.item(0);
        Assert.assertEquals((Object)"true", (Object)count.getAttributes().getNamedItem("xsd:nil").getTextContent());
        dateList = dom.getElementsByTagName("test:date");
        date = dateList.item(0);
        Assert.assertEquals((Object)"true", (Object)date.getAttributes().getNamedItem("xsd:nil").getTextContent());
    }

    private SimpleFeatureType buildTestFeatureType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(TEST.TestFeature.getLocalPart());
        typeBuilder.setNamespaceURI(TEST.TestFeature.getNamespaceURI());
        typeBuilder.add("name", String.class);
        typeBuilder.add("description", String.class);
        typeBuilder.add("geom", Point.class);
        typeBuilder.nillable(true);
        typeBuilder.add("count", Integer.class);
        typeBuilder.nillable(true);
        typeBuilder.add("date", Date.class);
        typeBuilder.add("data", String.class);
        typeBuilder.add("decimal", BigDecimal.class);
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        return type;
    }

    @Test
    public void testEncodeBigDecimal() throws Exception {
        SimpleFeatureType type = this.buildTestFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        builder.add((Object)"theName");
        builder.add((Object)"theDescription");
        builder.add((Object)GML3MockData.point());
        builder.add(null);
        builder.add(null);
        builder.add(null);
        builder.add((Object)new BigDecimal("0.000000015"));
        SimpleFeature feature = builder.buildFeature("fid.1");
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        encoder.setIndentSize(2);
        String xml = encoder.encodeAsString((Object)feature, TEST.TestFeature);
        MatcherAssert.assertThat((Object)xml, (Matcher)this.hasXPath("//test:decimal", CoreMatchers.equalTo((Object)"0.000000015")));
    }

    @Test
    public void testRemoveInvalidXMLChars() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)TEST.TestFeature.getNamespaceURI(), (String)TEST.TestFeature.getLocalPart(), (String)"the_geom:Point,data:String");
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{new WKTReader().read("POINT(0 0)"), "One \u0007 test"}, (String)"123");
        TestConfiguration configuration = new TestConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        String result = encoder.encodeAsString((Object)feature, TEST.TestFeature);
        MatcherAssert.assertThat((Object)result, (Matcher)this.hasXPath("//test:data", CoreMatchers.equalTo((Object)"One  test")));
    }

    @Test
    public void testEncodeFeatureMemberAttributes() throws Exception {
        SimpleFeature feature = GML3MockData.feature();
        HashMap<NameImpl, String> attributesMap = new HashMap<NameImpl, String>();
        attributesMap.put(new NameImpl("example"), "123");
        feature.getUserData().put(Attributes.class, attributesMap);
        GMLConfiguration configuration = new GMLConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration);
        Document dom = encoder.encodeAsDOM((Object)feature, GML.featureMember);
        Node featureNode = dom.getDocumentElement().getFirstChild();
        Assert.assertTrue((boolean)(featureNode instanceof Element));
        Element featureElement = (Element)featureNode;
        Assert.assertTrue((boolean)featureElement.hasAttribute("example"));
        Assert.assertFalse((boolean)dom.getDocumentElement().hasAttribute("example"));
    }
}

