/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.geometry.jts.WKTReader2;
import org.geotools.gml3.simple.GeometryEncoderTestSupport;
import org.geotools.gml3.simple.PolygonEncoder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Document;

public class CurvePolygonEncoderTest
extends GeometryEncoderTestSupport {
    @Test
    public void testCircle() throws Exception {
        PolygonEncoder encoder = new PolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Polygon geometry = (Polygon)new WKTReader2().read("CURVEPOLYGON(CIRCULARSTRING(-10 0, -8 2, -6 0, -8 -2, -10 0))");
        Document doc = this.encode(encoder, geometry);
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon/gml:exterior)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon/gml:interior)", CoreMatchers.equalTo((Object)"0")));
        String ext1 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[1]";
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(ext1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(ext1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"-10 0 -8 2 -6 0 -8 -2 -10 0")));
    }

    @Test
    public void testDonut() throws Exception {
        PolygonEncoder encoder = new PolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Polygon geometry = (Polygon)new WKTReader2().read("CURVEPOLYGON(CIRCULARSTRING(-7 -8, -5 -6, -3 -8, -5 -10, -7 -8),CIRCULARSTRING(-6 -8, -5 -7, -4 -8, -5 -9, -6 -8))");
        Document doc = this.encode(encoder, geometry);
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon/gml:exterior)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon/gml:interior)", CoreMatchers.equalTo((Object)"1")));
        String ext1 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[1]";
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(ext1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(ext1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"-7 -8 -5 -6 -3 -8 -5 -10 -7 -8")));
        String int1 = "//gml:Polygon/gml:interior/gml:Ring/gml:curveMember[1]";
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(int1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(int1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"-6 -8 -5 -7 -4 -8 -5 -9 -6 -8")));
    }

    @Test
    public void testComplex() throws Exception {
        PolygonEncoder encoder = new PolygonEncoder(this.gtEncoder, "gml", "http://www.opengis.net/gml");
        Polygon geometry = (Polygon)new WKTReader2().read("CURVEPOLYGON(COMPOUNDCURVE(CIRCULARSTRING(0 0, 2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)), CIRCULARSTRING(1.7 1, 1.4 0.4, 1.6 0.4, 1.6 0.5, 1.7 1) )");
        Document doc = this.encode(encoder, geometry);
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon/gml:exterior)", CoreMatchers.equalTo((Object)"1")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath("count(//gml:Polygon/gml:interior)", CoreMatchers.equalTo((Object)"1")));
        String ext1 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[1]";
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(ext1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(ext1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"0 0 2 0 2 1 2 3 4 3")));
        String ext2 = "//gml:Polygon/gml:exterior/gml:Ring/gml:curveMember[2]";
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(ext2 + "/gml:LineString/gml:posList", CoreMatchers.equalTo((Object)"4 3 4 5 1 4 0 0")));
        String int1 = "//gml:Polygon/gml:interior/gml:Ring/gml:curveMember[1]";
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(int1 + "/gml:Curve/gml:segments/gml:ArcString/@interpolation", CoreMatchers.equalTo((Object)"circularArc3Points")));
        MatcherAssert.assertThat((Object)doc, (Matcher)this.hasXPath(int1 + "/gml:Curve/gml:segments/gml:ArcString/gml:posList", CoreMatchers.equalTo((Object)"1.7 1 1.4 0.4 1.6 0.4 1.6 0.5 1.7 1")));
    }
}

