/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import java.net.URI;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.kml.FolderStack;
import org.geotools.kml.KML;
import org.geotools.kml.StyleMap;
import org.geotools.kml.v22.SchemaRegistry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;

public class FeatureTypeBinding
extends AbstractComplexBinding {
    protected static final SimpleFeatureType FeatureType;
    StyleMap styleMap;
    private final FolderStack folderStack;
    private SchemaRegistry schemaRegistry;

    public FeatureTypeBinding(StyleMap styleMap, FolderStack folderStack, SchemaRegistry schemaRegistry) {
        this.styleMap = styleMap;
        this.folderStack = folderStack;
        this.schemaRegistry = schemaRegistry;
    }

    public QName getTarget() {
        return KML.FeatureType;
    }

    public Class getType() {
        return SimpleFeature.class;
    }

    private SimpleFeatureType appendAttributes(SimpleFeatureType acc, SimpleFeatureType typeToAppend) {
        if (typeToAppend == null) {
            return acc;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(acc);
        for (AttributeDescriptor ad : typeToAppend.getAttributeDescriptors()) {
            if (acc.getDescriptor(ad.getLocalName()) != null) continue;
            tb.add(ad);
        }
        return tb.buildFeatureType();
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List schemaURI;
        SimpleFeatureType featureType = FeatureType;
        Map extData = (Map)node.getChildValue("ExtendedData");
        if (extData != null && (schemaURI = (List)extData.get("schemas")) != null) {
            for (URI uri2 : schemaURI) {
                String normalizedSchemaName = this.normalizeSchemaName(uri2);
                SimpleFeatureType schemaType = this.schemaRegistry.get(normalizedSchemaName);
                featureType = this.appendAttributes(featureType, schemaType);
            }
        }
        SimpleFeatureType customFeatureType = this.schemaRegistry.get(instance.getName());
        featureType = this.appendAttributes(featureType, customFeatureType);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        b.set("name", node.getChildValue("name"));
        b.set("visibility", node.getChildValue("visibility", (Object)Boolean.TRUE));
        b.set("open", node.getChildValue("open", (Object)Boolean.TRUE));
        b.set("address", node.getChildValue("address"));
        b.set("phoneNumber", node.getChildValue("phoneNumber"));
        b.set("description", node.getChildValue("description"));
        b.set("LookAt", node.getChildValue("LookAt"));
        URI uri = (URI)node.getChildValue("styleUrl");
        if (uri != null) {
            b.set("Style", (Object)this.styleMap.get(uri));
        }
        b.set("Region", node.getChildValue("Region"));
        if (extData != null) {
            b.featureUserData((Object)"UntypedExtendedData", extData.get("untyped"));
            Map typedUserData = (Map)extData.get("typed");
            if (typedUserData != null) {
                for (Map.Entry entry : typedUserData.entrySet()) {
                    String attrName = (String)entry.getKey();
                    if (featureType.getDescriptor(attrName) == null) continue;
                    b.set(attrName, entry.getValue());
                }
            }
        }
        if (customFeatureType != null) {
            for (AttributeDescriptor ad : customFeatureType.getAttributeDescriptors()) {
                String string = ad.getLocalName();
                Object childValue = node.getChildValue(string);
                if (childValue == null) continue;
                b.set(string, childValue);
            }
        }
        b.featureUserData((Object)"Folder", this.folderStack.asList());
        return b.buildFeature((String)node.getAttributeValue("id"));
    }

    private String normalizeSchemaName(URI schemaURI) {
        if (schemaURI.getFragment() != null) {
            return schemaURI.getFragment();
        }
        return schemaURI.getPath();
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (object instanceof FeatureCollection) {
            FeatureCollection features = (FeatureCollection)object;
            if ("id".equals(name.getLocalPart())) {
                return features.getID();
            }
        }
        if (object instanceof SimpleFeature) {
            URI uri;
            SimpleFeature feature = (SimpleFeature)object;
            if ("id".equals(name.getLocalPart())) {
                return feature.getID();
            }
            if ("name".equals(name.getLocalPart())) {
                return feature.getAttribute("name");
            }
            if ("description".equals(name.getLocalPart())) {
                return feature.getAttribute("description");
            }
            if (KML.styleUrl.getLocalPart().equals(name.getLocalPart()) && (uri = (URI)feature.getAttribute("Style")) != null) {
                return this.styleMap.get(uri);
            }
            if ("ExtendedData".equals(name.getLocalPart())) {
                SimpleFeatureType t = feature.getFeatureType();
                LinkedList<AbstractMap.SimpleEntry<Name, Object>> attributes = new LinkedList<AbstractMap.SimpleEntry<Name, Object>>();
                for (AttributeDescriptor ad : t.getAttributeDescriptors()) {
                    Object obj = feature.getAttribute(ad.getName());
                    if (obj instanceof Geometry) continue;
                    attributes.add(new AbstractMap.SimpleEntry<Name, Object>(ad.getName(), obj));
                }
                return attributes;
            }
        }
        return super.getProperty(object, name);
    }

    static {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setNamespaceURI("http://earth.google.com/kml/2.1");
        tb.setName("feature");
        tb.add("name", String.class);
        tb.add("visibility", Boolean.class);
        tb.add("open", Boolean.class);
        tb.add("address", String.class);
        tb.add("phoneNumber", String.class);
        tb.add("description", String.class);
        tb.add("LookAt", Point.class);
        tb.add("Style", FeatureTypeStyle.class);
        tb.add("Region", LinearRing.class);
        FeatureType = tb.buildFeatureType();
    }
}

