/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.geotools.kml.KML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;

public class LinearRingTypeBinding
extends AbstractComplexBinding {
    CoordinateSequenceFactory csFactory;
    GeometryFactory geometryFactory;

    public LinearRingTypeBinding(GeometryFactory geometryFactory, CoordinateSequenceFactory csFactory) {
        this.geometryFactory = geometryFactory;
        this.csFactory = csFactory;
    }

    public QName getTarget() {
        return KML.LinearRingType;
    }

    public Class getType() {
        return LinearRing.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Coordinate lastCoord;
        CoordinateSequence coordinates = (CoordinateSequence)node.getChildValue(KML.coordinates.getLocalPart());
        Coordinate firstCoord = coordinates.getCoordinate(0);
        if (!firstCoord.equals3D(lastCoord = coordinates.getCoordinate(coordinates.size() - 1))) {
            ArrayList<Coordinate> updateCoords = new ArrayList<Coordinate>(Arrays.asList(coordinates.toCoordinateArray()));
            updateCoords.add((Coordinate)firstCoord.clone());
            coordinates = this.csFactory.create(updateCoords.toArray(new Coordinate[0]));
        }
        return this.geometryFactory.createLinearRing(coordinates);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (KML.coordinates.getLocalPart().equals(name.getLocalPart())) {
            LinearRing l = (LinearRing)object;
            return l.getCoordinateSequence();
        }
        return null;
    }
}

