/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.se.v1_1.bindings;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.geotools.data.Base64;
import org.geotools.image.io.ImageIOExt;
import org.geotools.se.v1_1.SE;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

public class InlineContentBinding
extends AbstractComplexBinding {
    private static final Logger LOGGER = Logging.getLogger(InlineContentBinding.class);

    public QName getTarget() {
        return SE.InlineContent;
    }

    public Class getType() {
        return Icon.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String encoding = (String)node.getAttributeValue("encoding");
        if ("base64".equalsIgnoreCase(encoding)) {
            String base64 = value.toString();
            Icon icon = InlineContentBinding.parseIcon(base64);
            return icon;
        }
        throw new IllegalArgumentException("Encoding " + encoding + " not supported");
    }

    private static Icon parseIcon(String content) {
        BufferedImage image;
        block3: {
            byte[] bytes = Base64.decode((String)content);
            image = null;
            try {
                image = ImageIOExt.readBufferedImage((Object)new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                LOGGER.log(Level.WARNING, "could not parse graphic inline content: " + content, e);
            }
        }
        if (image == null) {
            LOGGER.warning("returning empty icon");
            return EmptyIcon.INSTANCE;
        }
        return new ImageIcon(image);
    }

    private static class EmptyIcon
    implements Icon {
        public static final EmptyIcon INSTANCE = new EmptyIcon();

        private EmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 1;
        }

        @Override
        public int getIconHeight() {
            return 1;
        }
    }
}

