/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.StyleFactory;
import org.geotools.sld.bindings.SLD;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class SLDColorMapEntryBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;
    FilterFactory filterFactory;

    public SLDColorMapEntryBinding(StyleFactory styleFactory, FilterFactory filterFactory) {
        this.styleFactory = styleFactory;
        this.filterFactory = filterFactory;
    }

    public QName getTarget() {
        return SLD.COLORMAPENTRY;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return ColorMapEntry.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ColorMapEntry entry = this.styleFactory.createColorMapEntry();
        Literal color = this.filterFactory.literal(node.getAttributeValue("color"));
        entry.setColor((Expression)color);
        if (node.getAttributeValue("opacity") != null) {
            Double opacity = (Double)node.getAttributeValue("opacity");
            entry.setOpacity((Expression)this.filterFactory.literal(opacity.doubleValue()));
        }
        if (node.getAttributeValue("quantity") != null) {
            Double quantity = (Double)node.getAttributeValue("quantity");
            entry.setQuantity((Expression)this.filterFactory.literal(quantity.doubleValue()));
        }
        if (node.getAttributeValue("label") != null) {
            String label = (String)node.getAttributeValue("label");
            entry.setLabel(label);
        }
        return entry;
    }
}

