/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.OverlapBehaviorEnum;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.StyleFactory;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class SLDRasterSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDRasterSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.RASTERSYMBOLIZER;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return RasterSymbolizer.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        RasterSymbolizer rs = this.styleFactory.createRasterSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                rs.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                rs.setGeometry(geometry);
            }
        }
        if (node.hasChild("Opacity")) {
            rs.setOpacity((Expression)node.getChildValue("Opacity"));
        }
        if (node.hasChild("ChannelSelection")) {
            rs.setChannelSelection((ChannelSelection)node.getChildValue("ChannelSelection"));
        }
        if (node.hasChild("OverlapBehavior")) {
            rs.setOverlapBehavior((OverlapBehaviorEnum)node.getChildValue("OverlapBehavior"));
        }
        if (node.hasChild("ColorMap")) {
            rs.setColorMap((ColorMap)node.getChildValue("ColorMap"));
        }
        if (node.hasChild("ContrastEnhancement")) {
            rs.setContrastEnhancement((ContrastEnhancement)node.getChildValue("ContrastEnhancement"));
        }
        if (node.hasChild("ShadedRelief")) {
            rs.setShadedRelief((ShadedRelief)node.getChildValue("ShadedRelief"));
        }
        if (node.hasChild("ImageOutline")) {
            ImageOutline imageOutput = (ImageOutline)node.getChildValue("ImageOutline");
            rs.setImageOutline(imageOutput.getSymbolizer());
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            rs.getOptions().put(param.getName(), (String)param.getExpression().evaluate(null, String.class));
        }
        return rs;
    }
}

