/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.filter.Filter;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.Rule;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.util.InternationalString;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class SLDRuleBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDRuleBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.RULE;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Rule.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Rule rule = this.styleFactory.createRule();
        if (node.hasChild("Name")) {
            rule.setName((String)node.getChildValue("Name"));
        }
        if (node.hasChild("Title")) {
            rule.getDescription().setTitle((InternationalString)node.getChildValue("Title"));
        }
        if (node.hasChild("Abstract")) {
            rule.getDescription().setAbstract((InternationalString)node.getChildValue("Abstract"));
        }
        if (node.hasChild("LegendGraphic")) {
            rule.setLegend((GraphicLegend)node.getChildValue("LegendGraphic"));
        }
        if (node.hasChild(Filter.class)) {
            rule.setFilter((Filter)node.getChildValue(Filter.class));
        } else if (node.hasChild("ElseFilter")) {
            rule.setElseFilter(true);
        }
        if (node.hasChild("MinScaleDenominator")) {
            rule.setMinScaleDenominator(((Double)node.getChildValue("MinScaleDenominator")).doubleValue());
        }
        if (node.hasChild("MaxScaleDenominator")) {
            rule.setMaxScaleDenominator(((Double)node.getChildValue("MaxScaleDenominator")).doubleValue());
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            rule.getOptions().put(param.getName(), (String)param.getExpression().evaluate(null, String.class));
        }
        List syms = node.getChildValues(Symbolizer.class);
        rule.symbolizers().addAll(syms);
        return rule;
    }
}

