/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2010, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.se.v1_1.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.style.StyleFactory;
import org.geotools.se.v1_1.SE;
import org.geotools.sld.bindings.SLDStrokeBinding;

/**
 * Binding object for the element http://www.opengis.net/se:Stroke.
 *
 * <p>
 *
 * <pre>
 *  <code>
 *  &lt;xsd:element name="Stroke" type="se:StrokeType"&gt;
 *      &lt;xsd:annotation&gt;
 *          &lt;xsd:documentation&gt;
 *          A "Stroke" specifies the appearance of a linear geometry.  It is
 *          defined in parallel with SVG strokes.  The following SvgParameters
 *          may be used: "stroke" (color), "stroke-opacity", "stroke-width",
 *          "stroke-linejoin", "stroke-linecap", "stroke-dasharray", and
 *          "stroke-dashoffset".  Others are not officially supported.
 *        &lt;/xsd:documentation&gt;
 *      &lt;/xsd:annotation&gt;
 *  &lt;/xsd:element&gt;
 *
 *   </code>
 * </pre>
 *
 * @generated
 */
public class StrokeBinding extends SLDStrokeBinding {

    public StrokeBinding(StyleFactory styleFactory, FilterFactory filterFactory) {
        super(styleFactory, filterFactory);
    }

    /** @generated */
    @Override
    public QName getTarget() {
        return SE.Stroke;
    }
}
