/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Halo;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class SLDTextSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDTextSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.TEXTSYMBOLIZER;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return TextSymbolizer.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        TextSymbolizer ts = this.styleFactory.createTextSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                ts.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                ts.setGeometry(geometry);
            }
        }
        if (node.hasChild("Label")) {
            ts.setLabel((Expression)node.getChildValue("Label"));
        }
        if (node.hasChild("Font")) {
            ts.fonts().add((Font)node.getChildValue("Font"));
        }
        if (node.hasChild("LabelPlacement")) {
            ts.setLabelPlacement((LabelPlacement)node.getChildValue("LabelPlacement"));
        }
        if (node.hasChild("Halo")) {
            ts.setHalo((Halo)node.getChildValue("Halo"));
        }
        if (node.hasChild("Fill")) {
            ts.setFill((Fill)node.getChildValue("Fill"));
        }
        if (node.hasChild("Graphic")) {
            ts.setGraphic((Graphic)node.getChildValue("Graphic"));
        }
        if (node.hasChild("Priority")) {
            ts.setPriority((Expression)node.getChildValue("Priority"));
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            ts.getOptions().put(param.getName(), (String)param.getExpression().evaluate(null, String.class));
        }
        return ts;
    }
}

