/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml4wcs.bindings;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.GeneralPosition;
import org.geotools.gml4wcs.GML;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.AttributeInstance;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvelopeTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.EnvelopeType;
    }

    public Class<GeneralBounds> getType() {
        return GeneralBounds.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List positions = node.getChildren("pos");
        if (!positions.isEmpty() && positions.size() == 2) {
            Node n1 = (Node)positions.get(0);
            Node n2 = (Node)positions.get(1);
            GeneralPosition p1 = (GeneralPosition)n1.getValue();
            GeneralPosition p2 = (GeneralPosition)n2.getValue();
            GeneralBounds envelope = new GeneralBounds(p1, p2);
            for (AttributeInstance att : instance.getAttributes()) {
                if (!att.getName().equals("srsName")) continue;
                envelope.setCoordinateReferenceSystem(CRS.decode((String)att.getText()));
            }
            return envelope;
        }
        if (!positions.isEmpty()) {
            throw new RuntimeException("Envelope can have only two coordinates");
        }
        throw new RuntimeException("Could not find coordinates for envelope");
    }

    public int getExecutionMode() {
        return 2;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        GeneralBounds envelope = (GeneralBounds)object;
        if (envelope == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", org.geotools.gml3.GML.Null.getLocalPart()));
        }
        return null;
    }

    public Object getProperty(Object object, QName name) {
        GeneralBounds envelope = (GeneralBounds)object;
        if (envelope == null) {
            return null;
        }
        if (name.getLocalPart().equals("srsName")) {
            try {
                return CRS.lookupIdentifier((IdentifiedObject)envelope.getCoordinateReferenceSystem(), (boolean)true);
            }
            catch (FactoryException e) {
                return null;
            }
        }
        if (name.getLocalPart().equals("pos")) {
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            GeographicCRS spatialCRS = null;
            if (crs instanceof CompoundCRS) {
                List CRSs = ((DefaultCompoundCRS)crs).getCoordinateReferenceSystems();
                for (Object item : CRSs) {
                    if (!(item instanceof GeographicCRS)) continue;
                    spatialCRS = (GeographicCRS)item;
                }
            } else {
                spatialCRS = (GeographicCRS)envelope.getCoordinateReferenceSystem();
            }
            if (spatialCRS != null) {
                LinkedList<GeneralPosition> envelopePositions = new LinkedList<GeneralPosition>();
                GeneralPosition lowerCorner = new GeneralPosition(envelope.getCoordinateReferenceSystem());
                GeneralPosition upperCorner = new GeneralPosition(envelope.getCoordinateReferenceSystem());
                for (int i = 0; i < spatialCRS.getCoordinateSystem().getDimension(); ++i) {
                    lowerCorner.setOrdinate(i, envelope.getLowerCorner().getOrdinate(i));
                    upperCorner.setOrdinate(i, envelope.getUpperCorner().getOrdinate(i));
                }
                envelopePositions.add(lowerCorner);
                envelopePositions.add(upperCorner);
                return envelopePositions;
            }
        }
        return null;
    }
}

