/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.gml3.v3_2.GML;
import org.geotools.xs.XS;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.filter.expression.PropertyName;

public class PropertyValueCollection
extends AbstractCollection<Attribute> {
    static FeatureTypeFactory typeFactory = new FeatureTypeFactoryImpl();
    static FeatureFactory factory = CommonFactoryFinder.getFeatureFactory(null);
    static final Name GML_IDENTIFIER = new NameImpl("http://www.opengis.net/gml/3.2", "identifier");
    static final AttributeDescriptor ID_DESCRIPTOR;
    FeatureCollection delegate;
    AttributeDescriptor descriptor;
    List<Schema> typeMappingProfiles = new ArrayList<Schema>();
    PropertyName propertyName;

    public PropertyValueCollection(FeatureCollection delegate, AttributeDescriptor descriptor, PropertyName propName) {
        this.delegate = delegate;
        this.descriptor = descriptor;
        this.typeMappingProfiles.add(XS.getInstance().getTypeMappingProfile());
        this.typeMappingProfiles.add(GML.getInstance().getTypeMappingProfile());
        this.propertyName = propName;
        if (descriptor == null) {
            this.descriptor = ID_DESCRIPTOR;
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new PropertyValueIterator(this.delegate.features());
    }

    static {
        AttributeTypeBuilder ab = new AttributeTypeBuilder(typeFactory);
        ab.setName("identifier");
        ab.setBinding(String.class);
        ID_DESCRIPTOR = ab.buildDescriptor("identifier");
    }

    class PropertyValueIterator
    implements Iterator<Attribute> {
        FeatureIterator it;
        Feature next;
        Queue<Object> values = new LinkedList<Object>();

        PropertyValueIterator(FeatureIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.it == null) {
                return false;
            }
            if (this.values.isEmpty()) {
                Object value = null;
                while (this.it.hasNext()) {
                    Feature f = this.it.next();
                    value = PropertyValueCollection.this.propertyName.evaluate((Object)f);
                    if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) continue;
                    this.next = f;
                    break;
                }
                if (value != null) {
                    if (value instanceof Collection) {
                        Collection values = (Collection)value;
                        this.values.addAll(values);
                    } else {
                        this.values.add(value);
                    }
                }
            }
            if (!this.values.isEmpty()) {
                return true;
            }
            this.it.close();
            this.it = null;
            return false;
        }

        @Override
        public Attribute next() {
            ComplexAttribute result;
            Object value = this.values.remove();
            AttributeType xmlType = this.findType(PropertyValueCollection.this.descriptor.getType().getBinding());
            if (xmlType == null) {
                throw new RuntimeException("Unable to map attribute " + String.valueOf(PropertyValueCollection.this.descriptor.getName()) + " to xml type");
            }
            Object name = PropertyValueCollection.this.descriptor == ID_DESCRIPTOR ? GML_IDENTIFIER : new NameImpl(this.next.getType().getName().getNamespaceURI(), PropertyValueCollection.this.descriptor.getLocalName());
            AttributeDescriptor newDescriptor = typeFactory.createAttributeDescriptor(xmlType, name, PropertyValueCollection.this.descriptor.getMinOccurs(), PropertyValueCollection.this.descriptor.getMaxOccurs(), PropertyValueCollection.this.descriptor.isNillable(), PropertyValueCollection.this.descriptor.getDefaultValue());
            if (value instanceof ComplexAttribute) {
                result = factory.createComplexAttribute(Collections.singletonList((Property)value), newDescriptor, null);
            } else {
                value = value instanceof Attribute ? ((Attribute)value).getValue() : value;
                result = factory.createAttribute(value, newDescriptor, null);
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        AttributeType findType(Class<?> binding) {
            for (Schema schema : PropertyValueCollection.this.typeMappingProfiles) {
                for (Map.Entry e : schema.entrySet()) {
                    AttributeType at = (AttributeType)e.getValue();
                    if (at.getBinding() == null || !at.getBinding().equals(binding)) continue;
                    return at;
                }
                for (AttributeType at : schema.values()) {
                    if (!binding.isAssignableFrom(at.getBinding())) continue;
                    return at;
                }
            }
            return null;
        }
    }
}

