/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.gml.producer.FeatureTransformer;
import org.geotools.gml2.ApplicationSchemaXSD;
import org.geotools.gml2.FeatureTypeCache;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml2.GMLSchema;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.referencing.CRS;
import org.geotools.util.PartiallyOrderedSet;
import org.geotools.wfs.WFS;
import org.geotools.wfs.gtxml.GTXML;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.wfs.v1_1.WFSConfiguration;
import org.geotools.xs.XS;
import org.geotools.xs.XSConfiguration;
import org.geotools.xs.XSSchema;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.geotools.xsd.StreamingParser;
import org.geotools.xsd.XSD;
import org.geotools.xsd.impl.ParserHandler;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.ComplexType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.Schema;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GML {
    private Charset encoding = Charset.forName("UTF-8");
    private URL baseURL;
    private Configuration gmlConfiguration;
    private String gmlNamespace;
    private String gmlLocation;
    private List<Schema> schemaList = new ArrayList<Schema>();
    String prefix = null;
    String namespace = null;
    private final Version version;
    private boolean legacy;
    private CoordinateReferenceSystem crs;

    public GML(Version version) {
        this.version = version;
        this.init();
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public void setNamespace(String prefix, String namespace) {
        this.prefix = prefix;
        this.namespace = namespace;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    protected void init() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add((Schema)new XSSchema().profile());
        SchemaImpl hack = new SchemaImpl("http://www.w3.org/2001/XMLSchema");
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.setName("date");
        builder.setBinding(Date.class);
        hack.put((Object)new NameImpl(XS.DATETIME), (Object)builder.buildType());
        schemas.add((Schema)hack);
        if (Version.GML2 == this.version) {
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlLocation = "gml/2.1.2/feature.xsd";
            this.gmlConfiguration = new GMLConfiguration();
            schemas.add((Schema)new GMLSchema().profile());
        }
        if (Version.WFS1_0 == this.version) {
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlLocation = "gml/2.1.2/feature.xsd";
            this.gmlConfiguration = new WFSConfiguration_1_0();
            schemas.add((Schema)new GMLSchema().profile());
        }
        if (Version.GML3 == this.version) {
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlLocation = "gml/3.1.1/base/gml.xsd";
            this.gmlConfiguration = new org.geotools.gml3.GMLConfiguration();
            schemas.add((Schema)new org.geotools.gml3.GMLSchema().profile());
        }
        if (Version.WFS1_1 == this.version) {
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlLocation = "gml/3.1.1/base/gml.xsd";
            this.gmlConfiguration = new WFSConfiguration();
            schemas.add((Schema)new org.geotools.gml3.GMLSchema().profile());
        }
        this.schemaList = schemas;
    }

    private Map.Entry<Name, AttributeType> searchSchemas(Class<?> binding) {
        Comparator<Map.Entry<Name, AttributeType>> sort = new Comparator<Map.Entry<Name, AttributeType>>(){

            @Override
            public int compare(Map.Entry<Name, AttributeType> o1, Map.Entry<Name, AttributeType> o2) {
                Class binding2;
                Class binding1 = o1.getValue().getBinding();
                if (binding1.equals(binding2 = o2.getValue().getBinding())) {
                    return 0;
                }
                if (binding1.isAssignableFrom(binding2)) {
                    return 1;
                }
                return 0;
            }
        };
        ArrayList<Map.Entry> match = new ArrayList<Map.Entry>();
        for (Schema profile : this.schemaList) {
            for (Map.Entry entry : profile.entrySet()) {
                AttributeType type = (AttributeType)entry.getValue();
                if (!type.getBinding().isAssignableFrom(binding)) continue;
                match.add(entry);
            }
        }
        Collections.sort(match, sort);
        Iterator iter = match.iterator();
        if (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            return entry;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(OutputStream out, SimpleFeatureCollection collection) throws IOException {
        if (this.version == Version.GML2) {
            if (!this.legacy) throw new IllegalStateException("Cannot encode a feature collection using GML2 (only WFS)");
            this.encodeLegacyGML2(out, collection);
            return;
        } else if (this.version == Version.WFS1_0) {
            WFSConfiguration_1_0 configuration = new WFSConfiguration_1_0();
            configuration.getProperties().add(GMLConfiguration.OPTIMIZED_ENCODING);
            Encoder e = new Encoder((Configuration)configuration);
            e.getNamespaces().declarePrefix(this.prefix, this.namespace);
            e.setIndenting(true);
            FeatureCollectionType featureCollectionType = WfsFactory.eINSTANCE.createFeatureCollectionType();
            featureCollectionType.getFeature().add((Object)collection);
            e.encode((Object)featureCollectionType, WFS.FeatureCollection, out);
            return;
        } else {
            if (this.version != Version.WFS1_1) throw new IllegalStateException("Unable to handle requested version");
            WFSConfiguration configuration = new WFSConfiguration();
            configuration.getProperties().add(GMLConfiguration.OPTIMIZED_ENCODING);
            Encoder e = new Encoder((Configuration)configuration);
            e.getNamespaces().declarePrefix(this.prefix, this.namespace);
            e.setIndenting(true);
            FeatureCollectionType featureCollectionType = WfsFactory.eINSTANCE.createFeatureCollectionType();
            featureCollectionType.getFeature().add((Object)collection);
            e.encode((Object)featureCollectionType, WFS.FeatureCollection, out);
        }
    }

    private void encodeLegacyGML2(OutputStream out, SimpleFeatureCollection collection) throws IOException {
        SimpleFeatureType TYPE = (SimpleFeatureType)collection.getSchema();
        FeatureTransformer transform = new FeatureTransformer();
        transform.setIndentation(4);
        transform.setGmlPrefixing(true);
        if (this.prefix != null && this.namespace != null) {
            transform.getFeatureTypeNamespaces().declareDefaultNamespace(this.prefix, this.namespace);
            transform.addSchemaLocation(this.prefix, this.namespace);
        }
        if (TYPE.getName().getNamespaceURI() != null && TYPE.getUserData().get("prefix") != null) {
            String typeNamespace = TYPE.getName().getNamespaceURI();
            String typePrefix = (String)TYPE.getUserData().get("prefix");
            transform.getFeatureTypeNamespaces().declareNamespace((FeatureType)TYPE, typePrefix, typeNamespace);
        } else if (this.prefix != null && this.namespace != null) {
            transform.getFeatureTypeNamespaces().declareNamespace((FeatureType)TYPE, this.prefix, this.namespace);
        }
        transform.setCollectionPrefix(null);
        transform.setCollectionNamespace(null);
        transform.setCollectionBounding(true);
        transform.setEncoding(this.encoding);
        transform.getFeatureNamespaces();
        String srsName = CRS.toSRS((CoordinateReferenceSystem)TYPE.getCoordinateReferenceSystem());
        if (srsName != null) {
            transform.setSrsName(srsName);
        }
        try {
            transform.transform((Object)collection, out);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException("Failed to encode feature collection:" + e).initCause(e);
        }
    }

    public void encode(OutputStream out, SimpleFeatureType simpleFeatureType) throws IOException {
        XSDSchema xsd = this.xsd(simpleFeatureType);
        XSDResourceImpl.serialize((OutputStream)out, (Element)xsd.getElement(), (String)this.encoding.name());
    }

    public SimpleFeatureType decodeSimpleFeatureType(URL schemaLocation, Name typeName) throws IOException {
        if (Version.WFS1_1 == this.version) {
            QName featureName = new QName(typeName.getNamespaceURI(), typeName.getLocalPart());
            String namespaceURI = featureName.getNamespaceURI();
            String uri = schemaLocation.toExternalForm();
            ApplicationSchemaConfiguration wfsConfiguration = new ApplicationSchemaConfiguration(namespaceURI, uri);
            FeatureType parsed = GTXML.parseFeatureType((Configuration)wfsConfiguration, featureName, this.crs);
            return DataUtilities.simple((FeatureType)parsed);
        }
        if (Version.WFS1_0 == this.version) {
            QName featureName = new QName(typeName.getNamespaceURI(), typeName.getLocalPart());
            String namespaceURI = featureName.getNamespaceURI();
            String uri = schemaLocation.toExternalForm();
            ApplicationSchemaXSD xsd = new ApplicationSchemaXSD(namespaceURI, uri);
            Configuration configuration = new Configuration((XSD)xsd){
                {
                    this.addDependency((Configuration)new XSConfiguration());
                    this.addDependency(GML.this.gmlConfiguration);
                }

                protected void registerBindings(Map bindings) {
                }
            };
            FeatureType parsed = GTXML.parseFeatureType(configuration, featureName, this.crs);
            return DataUtilities.simple((FeatureType)parsed);
        }
        return null;
    }

    public SimpleFeatureCollection decodeFeatureCollection(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        return this.decodeFeatureCollection(in, false);
    }

    public SimpleFeatureCollection decodeFeatureCollection(InputStream in, boolean computeFullFeatureType) throws IOException, SAXException, ParserConfigurationException {
        if (Version.GML2 == this.version || Version.WFS1_0 == this.version || Version.GML2 == this.version || Version.GML3 == this.version || Version.WFS1_0 == this.version || Version.WFS1_1 == this.version) {
            Configuration cfg = this.gmlConfiguration;
            Parser parser = new Parser(cfg);
            DynamicFeatureTypeCacheCustomizer customizer = null;
            if (computeFullFeatureType) {
                customizer = new DynamicFeatureTypeCacheCustomizer();
                parser.setContextCustomizer((ParserHandler.ContextCustomizer)customizer);
            }
            Object obj = parser.parse(in);
            SimpleFeatureCollection collection = this.toFeatureCollection(obj);
            if (computeFullFeatureType && customizer.isDynamicTypeFound()) {
                SimpleFeatureType harmonizedType = this.getCompleteFeatureType(collection);
                collection = new ReTypingFeatureCollection(collection, harmonizedType);
            }
            return collection;
        }
        return null;
    }

    private SimpleFeatureType getCompleteFeatureType(SimpleFeatureCollection collection) {
        if (collection.isEmpty()) {
            return (SimpleFeatureType)collection.getSchema();
        }
        PartiallyOrderedSet attributes = new PartiallyOrderedSet();
        HashSet attributeNames = new HashSet();
        String typeName = null;
        try (SimpleFeatureIterator fi = collection.features();){
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                SimpleFeatureType type = f.getFeatureType();
                if (typeName == null) {
                    typeName = type.getTypeName();
                }
                List descriptorList = f.getFeatureType().getAttributeDescriptors();
                for (int i = 0; i < descriptorList.size(); ++i) {
                    AttributeDescriptor curr = (AttributeDescriptor)descriptorList.get(i);
                    String name = curr.getLocalName();
                    if (attributeNames.contains(name)) continue;
                    attributes.add((Object)curr);
                    if (i > 0) {
                        AttributeDescriptor prev = (AttributeDescriptor)descriptorList.get(i - 1);
                        attributes.setOrder((Object)prev, (Object)curr);
                    }
                    if (i >= descriptorList.size() - 1) continue;
                    AttributeDescriptor next = (AttributeDescriptor)descriptorList.get(i + 1);
                    attributes.add((Object)next);
                    attributes.setOrder((Object)curr, (Object)next);
                }
            }
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        for (AttributeDescriptor ad : attributes) {
            tb.add(ad);
        }
        return tb.buildFeatureType();
    }

    private SimpleFeatureCollection toFeatureCollection(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof SimpleFeatureCollection) {
            return (SimpleFeatureCollection)obj;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            SimpleFeatureCollection simpleFeatureCollection = this.simpleFeatureCollection(collection);
            return simpleFeatureCollection;
        }
        if (obj instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)obj;
            return DataUtilities.collection((SimpleFeature)feature);
        }
        if (obj instanceof FeatureCollectionType) {
            FeatureCollectionType collectionType = (FeatureCollectionType)obj;
            for (Object entry : collectionType.getFeature()) {
                SimpleFeatureCollection collection = this.toFeatureCollection(entry);
                if (entry == null) continue;
                return collection;
            }
            return null;
        }
        throw new ClassCastException(obj.getClass() + " produced when FeatureCollection expected check schema use of AbstractFeatureCollection");
    }

    public SimpleFeatureIterator decodeFeatureIterator(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        return this.decodeFeatureIterator(in, null);
    }

    public SimpleFeatureIterator decodeFeatureIterator(InputStream in, QName elementName) throws IOException, ParserConfigurationException, SAXException {
        if (Version.GML2 == this.version || Version.GML3 == this.version || Version.WFS1_0 == this.version || Version.WFS1_1 == this.version) {
            StreamingParser parser = elementName != null ? new StreamingParser(this.gmlConfiguration, in, elementName) : new StreamingParser(this.gmlConfiguration, in, SimpleFeature.class);
            return this.iterator(parser);
        }
        return null;
    }

    private SimpleFeatureCollection simpleFeatureCollection(Collection<?> collection) {
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection();
        SimpleFeatureType schema = null;
        for (Object obj : collection) {
            if (schema == null) {
                schema = this.simpleType(obj);
            }
            SimpleFeature feature = this.simpleFeature(obj, schema);
            featureCollection.add(feature);
        }
        return featureCollection;
    }

    protected SimpleFeatureIterator iterator(final StreamingParser parser) {
        return new SimpleFeatureIterator(){
            SimpleFeatureType schema;
            Object next;

            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                this.next = parser.parse();
                return this.next != null;
            }

            public SimpleFeature next() {
                if (this.next == null) {
                    this.next = parser.parse();
                }
                if (this.next != null) {
                    try {
                        SimpleFeature feature;
                        if (this.schema == null) {
                            this.schema = GML.this.simpleType(this.next);
                        }
                        SimpleFeature simpleFeature = feature = GML.this.simpleFeature(this.next, this.schema);
                        return simpleFeature;
                    }
                    finally {
                        this.next = null;
                    }
                }
                return null;
            }

            public void close() {
                this.schema = null;
            }
        };
    }

    protected SimpleFeatureType simpleType(Object obj) {
        if (obj instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)obj;
            return feature.getFeatureType();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
            build.setName("Unknown");
            for (Map.Entry entry : map.entrySet()) {
                Class binding;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Class clazz = binding = value == null ? Object.class : value.getClass();
                if (value instanceof Geometry) {
                    Geometry geom = (Geometry)value;
                    Object srs = geom.getUserData();
                    if (srs instanceof CoordinateReferenceSystem) {
                        build.add(key, binding, (CoordinateReferenceSystem)srs);
                        continue;
                    }
                    if (srs instanceof Integer) {
                        build.add(key, binding, (Integer)srs);
                        continue;
                    }
                    if (srs instanceof String) {
                        build.add(key, binding, (String)srs);
                        continue;
                    }
                    build.add(key, binding);
                    continue;
                }
                build.add(key, binding);
            }
            SimpleFeatureType schema = build.buildFeatureType();
            return schema;
        }
        if (obj instanceof Geometry) {
            Geometry geom = (Geometry)obj;
            Class<?> binding = geom.getClass();
            Object srs = geom.getUserData();
            SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
            build.setName("Unknown");
            if (srs instanceof CoordinateReferenceSystem) {
                build.add("the_geom", binding, (CoordinateReferenceSystem)srs);
            } else if (srs instanceof Integer) {
                build.add("the_geom", binding, (Integer)srs);
            } else if (srs instanceof String) {
                build.add("the_geom", binding, (String)srs);
            } else {
                build.add("the_geom", binding);
            }
            build.setDefaultGeometry("the_geom");
            SimpleFeatureType schema = build.buildFeatureType();
            return schema;
        }
        return null;
    }

    protected SimpleFeature simpleFeature(Object obj, SimpleFeatureType schema) {
        if (schema == null) {
            schema = this.simpleType(obj);
        }
        if (obj instanceof SimpleFeature) {
            return (SimpleFeature)obj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            Object[] values = new Object[schema.getAttributeCount()];
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeDescriptor descriptor = schema.getDescriptor(i);
                String key = descriptor.getLocalName();
                Object value = map.get(key);
                values[i] = value;
            }
            SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])values, null);
            return feature;
        }
        if (obj instanceof Geometry) {
            Geometry geom = (Geometry)obj;
            SimpleFeatureBuilder build = new SimpleFeatureBuilder(schema);
            build.set(schema.getGeometryDescriptor().getName(), (Object)geom);
            SimpleFeature feature = build.buildFeature(null);
            return feature;
        }
        return null;
    }

    protected XSDSchema xsd(SimpleFeatureType simpleFeatureType) throws IOException {
        XSDFactory factory = XSDFactory.eINSTANCE;
        XSDSchema xsd = factory.createXSDSchema();
        xsd.setSchemaForSchemaQNamePrefix("xsd");
        xsd.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        xsd.setElementFormDefault(XSDForm.get((int)0));
        if (this.baseURL == null) {
            throw new IllegalStateException("Please setBaseURL prior to encoding");
        }
        if (this.prefix != null || this.namespace != null) {
            xsd.setTargetNamespace(this.namespace);
            xsd.getQNamePrefixToNamespaceMap().put(this.prefix, this.namespace);
        }
        if (simpleFeatureType.getName().getNamespaceURI() != null && simpleFeatureType.getUserData().get("prefix") != null) {
            String providedNamespace = simpleFeatureType.getName().getNamespaceURI();
            String providedPrefix = (String)simpleFeatureType.getUserData().get("prefix");
            xsd.getQNamePrefixToNamespaceMap().put(providedPrefix, providedNamespace);
        }
        if (simpleFeatureType.getUserData().get("schemaURI") != null) {
            throw new IllegalArgumentException("Unable to support app-schema supplied types");
        }
        XSDImport gml = factory.createXSDImport();
        gml.setNamespace(this.gmlNamespace);
        gml.setSchemaLocation(this.baseURL.toString() + "/" + this.gmlLocation);
        gml.setResolvedSchema(this.gmlConfiguration.getXSD().getSchema());
        xsd.getContents().add((Object)gml);
        xsd.getQNamePrefixToNamespaceMap().put("gml", this.gmlNamespace);
        xsd.getQNamePrefixToNamespaceMap().put("gml", "http://www.opengis.net/gml");
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(simpleFeatureType.getTypeName());
        XSDElementDeclaration _FEATURE = xsd.resolveElementDeclaration(this.gmlNamespace, "_Feature");
        element.setSubstitutionGroupAffiliation(_FEATURE);
        XSDComplexTypeDefinition ABSTRACT_FEATURE_TYPE = xsd.resolveComplexTypeDefinition(this.gmlNamespace, "AbstractFeatureType");
        XSDComplexTypeDefinition featureType = this.xsd(xsd, (ComplexType)simpleFeatureType, ABSTRACT_FEATURE_TYPE);
        element.setTypeDefinition((XSDTypeDefinition)featureType);
        xsd.getContents().add((Object)element);
        xsd.updateElement();
        return xsd;
    }

    protected XSDComplexTypeDefinition xsd(XSDSchema xsd, ComplexType type, XSDComplexTypeDefinition BASE_TYPE) {
        XSDFactory factory = XSDFactory.eINSTANCE;
        XSDComplexTypeDefinition definition = factory.createXSDComplexTypeDefinition();
        definition.setName(type.getName().getLocalPart());
        definition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        if (BASE_TYPE != null) {
            definition.setBaseTypeDefinition((XSDTypeDefinition)BASE_TYPE);
        }
        List<Object> skip = Collections.emptyList();
        if (BASE_TYPE != null && "AbstractFeatureType".equals(BASE_TYPE.getName())) {
            skip = Arrays.asList("nounds", "description", "boundedBy");
        }
        XSDModelGroup attributes = factory.createXSDModelGroup();
        attributes.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        NameImpl anyName = new NameImpl("http://www.w3.org/2001/XMLSchema", XS.ANYTYPE.getLocalPart());
        for (PropertyDescriptor descriptor : type.getDescriptors()) {
            AttributeDescriptor attributeDescriptor;
            if (!(descriptor instanceof AttributeDescriptor) || skip.contains((attributeDescriptor = (AttributeDescriptor)descriptor).getLocalName())) continue;
            XSDElementDeclaration attribute = factory.createXSDElementDeclaration();
            attribute.setName(attributeDescriptor.getLocalName());
            attribute.setNillable(attributeDescriptor.isNillable());
            Name name = attributeDescriptor.getType().getName();
            if (!anyName.equals((Object)name)) {
                AttributeType attributeType = attributeDescriptor.getType();
                if (attributeType instanceof ComplexType) {
                    ComplexType complexType = (ComplexType)attributeType;
                    if (xsd.resolveTypeDefinition(name.getNamespaceURI(), name.getLocalPart()) == null) {
                        this.xsd(xsd, complexType, null);
                    }
                } else {
                    Class binding = attributeType.getBinding();
                    Map.Entry<Name, AttributeType> entry = this.searchSchemas(binding);
                    if (entry == null) {
                        throw new IllegalStateException("No type for " + attribute.getName() + " (" + binding.getName() + ")");
                    }
                    name = entry.getKey();
                }
            }
            XSDTypeDefinition attributeDefinition = xsd.resolveTypeDefinition(name.getNamespaceURI(), name.getLocalPart());
            attribute.setTypeDefinition(attributeDefinition);
            XSDParticle particle = factory.createXSDParticle();
            particle.setMinOccurs(attributeDescriptor.getMinOccurs());
            particle.setMaxOccurs(attributeDescriptor.getMaxOccurs());
            particle.setContent((XSDParticleContent)attribute);
            attributes.getContents().add((Object)particle);
        }
        XSDParticle contents = factory.createXSDParticle();
        contents.setContent((XSDParticleContent)attributes);
        definition.setContent((XSDComplexTypeContent)contents);
        xsd.getContents().add((Object)definition);
        return definition;
    }

    private static class DynamicFeatureTypeCacheCustomizer
    implements ParserHandler.ContextCustomizer {
        boolean dynamicTypeFound = false;
        FeatureTypeCache dynamicFeatureTypeCache = new FeatureTypeCache(){

            public void put(FeatureType type) {
                if (Boolean.TRUE.equals(type.getUserData().get(GML2ParsingUtils.PARSED_FROM_SCHEMA_KEY))) {
                    super.put(type);
                } else {
                    dynamicTypeFound = true;
                }
            }
        };

        private DynamicFeatureTypeCacheCustomizer() {
        }

        public boolean isDynamicTypeFound() {
            return this.dynamicTypeFound;
        }

        public void customizeContext(MutablePicoContainer context) {
            Object instance = context.getComponentInstanceOfType(FeatureTypeCache.class);
            context.unregisterComponentByInstance(instance);
            context.registerComponentInstance((Object)this.dynamicFeatureTypeCache);
        }
    }

    public static enum Version {
        GML2,
        GML3,
        WFS1_0,
        WFS1_1;

    }
}

