/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v1_1;

import javax.xml.namespace.QName;
import net.opengis.wfs.PropertyType;
import net.opengis.wfs.WfsFactory;
import org.eclipse.emf.ecore.EFactory;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.simple.GenericGeometryEncoder;
import org.geotools.wfs.WFS;
import org.geotools.xsd.AbstractComplexEMFBinding;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class PropertyTypeBinding_1_1
extends AbstractComplexEMFBinding {
    private final GMLConfiguration gml;
    private final GenericGeometryEncoder geometryEncoder;
    private static final String VALUE = "Value";

    public PropertyTypeBinding_1_1(WfsFactory factory, Configuration configuration) {
        super((EFactory)factory);
        this.gml = this.initializeGMLConfiguration(configuration);
        Encoder encoder = new Encoder((Configuration)this.gml);
        encoder.setInline(true);
        this.geometryEncoder = new GenericGeometryEncoder(encoder);
    }

    @Deprecated
    public PropertyTypeBinding_1_1(WfsFactory factory) {
        this(factory, null);
    }

    private GMLConfiguration initializeGMLConfiguration(Configuration configuration) {
        if (configuration == null) {
            return new GMLConfiguration();
        }
        GMLConfiguration gml = (GMLConfiguration)configuration.getDependency(GMLConfiguration.class);
        return gml == null ? new GMLConfiguration() : gml;
    }

    public QName getTarget() {
        return WFS.PropertyType;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        return value;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return super.parse(instance, node, value);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        if (VALUE.equals(name.getLocalPart())) {
            return output -> {
                Object value = ((PropertyType)object).getValue();
                output.startElement("http://www.opengis.net/wfs", VALUE, "wfs:Value", new AttributesImpl());
                if (value instanceof Geometry) {
                    Geometry geometry = (Geometry)value;
                    GMLWriter handler = new GMLWriter(output, new NamespaceSupport(), this.gml.getNumDecimals(), this.gml.getForceDecimalEncoding(), this.gml.getPadWithZeros(), "gml", this.gml.getEncodeMeasures());
                    this.geometryEncoder.encode(geometry, new AttributesImpl(), handler);
                } else {
                    String s = value.toString();
                    output.characters(s.toCharArray(), 0, s.length());
                }
                output.endElement("http://www.opengis.net/wfs", VALUE, "wfs:Value");
            };
        }
        return super.getProperty(object, name);
    }
}

