/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.bindings;

import java.net.URI;
import java.util.Collection;
import javax.xml.namespace.QName;
import net.opengis.wfs.IdentifierGenerationOptionType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.WfsFactory;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml2.bindings.GML2ParsingUtils;
import org.geotools.gml3.GML;
import org.geotools.wfs.WFS;
import org.geotools.xsd.AbstractComplexEMFBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.picocontainer.MutablePicoContainer;

public class InsertElementTypeBinding
extends AbstractComplexEMFBinding {
    WfsFactory wfsfactory;

    public InsertElementTypeBinding(WfsFactory wfsfactory) {
        this.wfsfactory = wfsfactory;
    }

    public QName getTarget() {
        return WFS.InsertElementType;
    }

    public Class getType() {
        return InsertElementType.class;
    }

    public void initializeChildContext(ElementInstance childInstance, Node node, MutablePicoContainer context) {
        if (node.hasAttribute("srsName")) {
            try {
                CoordinateReferenceSystem crs = GML2ParsingUtils.crs((Node)node);
                if (crs != null) {
                    context.registerComponentInstance(CoordinateReferenceSystem.class, (Object)crs);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        InsertElementType insertElement = this.wfsfactory.createInsertElementType();
        if (node.hasChild(FeatureCollection.class)) {
            SimpleFeatureCollection fc = (SimpleFeatureCollection)node.getChildValue(FeatureCollection.class);
            insertElement.getFeature().addAll((Collection)DataUtilities.list((FeatureCollection)fc));
        } else if (node.hasChild(SimpleFeature.class)) {
            insertElement.getFeature().addAll((Collection)node.getChildValues(SimpleFeature.class));
        }
        if (node.hasAttribute("idgen")) {
            insertElement.setIdgen((IdentifierGenerationOptionType)node.getAttributeValue("idgen"));
        }
        if (node.hasAttribute("handle")) {
            insertElement.setHandle((String)node.getAttributeValue("handle"));
        }
        if (node.hasAttribute("inputFormat")) {
            insertElement.setInputFormat((String)node.getAttributeValue("inputFormat"));
        }
        if (node.hasAttribute("srsName")) {
            insertElement.setSrsName((URI)node.getAttributeValue("srsName"));
        }
        return insertElement;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        InsertElementType insert = (InsertElementType)object;
        if (GML._Feature.equals(name)) {
            return insert.getFeature();
        }
        return super.getProperty(object, name);
    }
}

