/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wmts.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import net.opengis.wmts.v_1.TileMatrixLimitsType;
import net.opengis.wmts.v_1.wmtsv_1Factory;
import org.geotools.wmts.WMTS;
import org.geotools.xsd.AbstractComplexEMFBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TileMatrixLimitsBinding
extends AbstractComplexEMFBinding {
    wmtsv_1Factory factory;

    public TileMatrixLimitsBinding(wmtsv_1Factory factory) {
        this.factory = factory;
    }

    public QName getTarget() {
        return WMTS.TileMatrixLimits;
    }

    public Class getType() {
        return TileMatrixLimitsType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        TileMatrixLimitsType limits = this.factory.createTileMatrixLimitsType();
        limits.setTileMatrix((String)node.getChildValue("TileMatrix"));
        limits.setMaxTileCol(TileMatrixLimitsBinding.toBigInt(node.getChildValue("MaxTileCol")));
        limits.setMaxTileRow(TileMatrixLimitsBinding.toBigInt(node.getChildValue("MaxTileRow")));
        limits.setMinTileCol(TileMatrixLimitsBinding.toBigInt(node.getChildValue("MinTileCol")));
        limits.setMinTileRow(TileMatrixLimitsBinding.toBigInt(node.getChildValue("MinTileRow")));
        return limits;
    }

    private static BigInteger toBigInt(Object o) {
        return BigInteger.valueOf(((Integer)o).longValue());
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        Element e = super.encode(object, document, value);
        TileMatrixLimitsType matrixLimit = (TileMatrixLimitsType)object;
        if (matrixLimit.getTileMatrix() != null) {
            Element tileMatrixNode = document.createElementNS("http://www.opengis.net/wmts/1.0", "TileMatrix");
            tileMatrixNode.setTextContent(matrixLimit.getTileMatrix());
            e.appendChild(tileMatrixNode);
        }
        return e;
    }
}

