/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.azure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.azure.AzureBlobStore;
import org.geowebcache.azure.AzureBlobStoreData;
import org.geowebcache.azure.PropertiesLoader;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.FileResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.NoOpLockProvider;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractAzureBlobStoreIntegrationTest {
    private static Logger log = Logging.getLogger((String)PropertiesLoader.class.getName());
    private static final String DEFAULT_FORMAT = "png";
    private static final String DEFAULT_GRIDSET = "EPSG:4326";
    private static final String DEFAULT_LAYER = "topp:world";
    public PropertiesLoader testConfigLoader = new PropertiesLoader();
    private AzureBlobStore blobStore;

    protected abstract AzureBlobStoreData getConfiguration();

    @Before
    public void before() throws Exception {
        AzureBlobStoreData config = this.getConfiguration();
        TileLayerDispatcher layers = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        NoOpLockProvider lockProvider = new NoOpLockProvider();
        TileLayer layer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)layers.getTileLayer((String)ArgumentMatchers.eq((Object)DEFAULT_LAYER))).thenReturn((Object)layer);
        Mockito.when((Object)layer.getName()).thenReturn((Object)DEFAULT_LAYER);
        Mockito.when((Object)layer.getId()).thenReturn((Object)DEFAULT_LAYER);
        this.blobStore = new AzureBlobStore(config, layers, (LockProvider)lockProvider);
    }

    @After
    public void after() {
        if (this.blobStore != null) {
            this.blobStore.destroy();
        }
    }

    @Test
    public void testPutGet() throws MimeException, StorageException {
        byte[] bytes = new byte[1024];
        Arrays.fill(bytes, (byte)-81);
        TileObject tile = this.queryTile(20L, 30L, 12);
        tile.setBlob((Resource)new ByteArrayResource(bytes));
        this.blobStore.put(tile);
        TileObject queryTile = this.queryTile(20L, 30L, 12);
        boolean found = this.blobStore.get(queryTile);
        Assert.assertTrue((boolean)found);
        Resource resource = queryTile.getBlob();
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((long)bytes.length, (long)resource.getSize());
    }

    @Test
    public void testPutGetBlobIsNotByteArrayResource() throws MimeException, IOException {
        File tileFile = File.createTempFile("tile", ".png");
        Files.write((byte[])new byte[1024], (File)tileFile);
        FileResource blob = new FileResource(tileFile);
        TileObject tile = this.queryTile(20L, 30L, 12);
        tile.setBlob((Resource)blob);
        this.blobStore.put(tile);
        TileObject queryTile = this.queryTile(20L, 30L, 12);
        boolean found = this.blobStore.get(queryTile);
        Assert.assertTrue((boolean)found);
        Resource resource = queryTile.getBlob();
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((long)1024L, (long)resource.getSize());
    }

    @Test
    public void testPutWithListener() throws MimeException, StorageException {
        byte[] bytes = new byte[1024];
        Arrays.fill(bytes, (byte)-81);
        TileObject tile = this.queryTile(20L, 30L, 12);
        tile.setBlob((Resource)new ByteArrayResource(bytes));
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        this.blobStore.put(tile);
        ((BlobStoreListener)Mockito.verify((Object)listener)).tileStored((String)ArgumentMatchers.eq((Object)tile.getLayerName()), (String)ArgumentMatchers.eq((Object)tile.getGridSetId()), (String)ArgumentMatchers.eq((Object)tile.getBlobFormat()), ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)20L), ArgumentMatchers.eq((long)30L), ArgumentMatchers.eq((int)12), ArgumentMatchers.eq((long)bytes.length));
        tile = this.queryTile(20L, 30L, 12);
        tile.setBlob((Resource)new ByteArrayResource(new byte[512]));
        this.blobStore.put(tile);
        ((BlobStoreListener)Mockito.verify((Object)listener)).tileUpdated((String)ArgumentMatchers.eq((Object)tile.getLayerName()), (String)ArgumentMatchers.eq((Object)tile.getGridSetId()), (String)ArgumentMatchers.eq((Object)tile.getBlobFormat()), ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)20L), ArgumentMatchers.eq((long)30L), ArgumentMatchers.eq((int)12), ArgumentMatchers.eq((long)512L), ArgumentMatchers.eq((long)1024L));
    }

    @Test
    public void testDelete() throws MimeException, StorageException {
        byte[] bytes = new byte[1024];
        Arrays.fill(bytes, (byte)-81);
        TileObject tile = this.queryTile(20L, 30L, 12);
        tile.setBlob((Resource)new ByteArrayResource(bytes));
        this.blobStore.put(tile);
        tile.getXYZ()[0] = 21L;
        this.blobStore.put(tile);
        tile.getXYZ()[0] = 22L;
        this.blobStore.put(tile);
        tile = this.queryTile(20L, 30L, 12);
        Assert.assertTrue((boolean)this.blobStore.delete(tile));
        tile.getXYZ()[0] = 21L;
        Assert.assertTrue((boolean)this.blobStore.delete(tile));
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        tile.getXYZ()[0] = 22L;
        Assert.assertTrue((boolean)this.blobStore.delete(tile));
        Assert.assertFalse((boolean)this.blobStore.delete(tile));
        ((BlobStoreListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)1))).tileDeleted((String)ArgumentMatchers.eq((Object)tile.getLayerName()), (String)ArgumentMatchers.eq((Object)tile.getGridSetId()), (String)ArgumentMatchers.eq((Object)tile.getBlobFormat()), ArgumentMatchers.anyString(), ArgumentMatchers.eq((long)22L), ArgumentMatchers.eq((long)30L), ArgumentMatchers.eq((int)12), ArgumentMatchers.eq((long)1024L));
    }

    @Test
    public void testRenameNoTiles() throws StorageException {
        String newName = "foobarLayer";
        this.blobStore.rename(DEFAULT_LAYER, newName);
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        ((BlobStoreListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).layerRenamed(DEFAULT_LAYER, newName);
    }

    @Test
    public void testRenameWithTiles() throws StorageException {
        byte[] bytes = new byte[1024];
        Arrays.fill(bytes, (byte)-81);
        TileObject tile = this.queryTile(20L, 30L, 12);
        tile.setBlob((Resource)new ByteArrayResource(bytes));
        this.blobStore.put(tile);
        String newName = "foobarLayer";
        this.blobStore.rename(DEFAULT_LAYER, newName);
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        ((BlobStoreListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).layerRenamed(DEFAULT_LAYER, newName);
    }

    @Test
    public void testDeleteLayer() throws Exception {
        this.blobStore.putLayerMetadata(DEFAULT_LAYER, "prop1", "value1");
        byte[] bytes = new byte[1024];
        Arrays.fill(bytes, (byte)-81);
        TileObject tile = this.queryTile(20L, 30L, 12);
        tile.setBlob((Resource)new ByteArrayResource(bytes));
        this.blobStore.put(tile);
        tile.getXYZ()[0] = 21L;
        this.blobStore.put(tile);
        tile.getXYZ()[0] = 22L;
        this.blobStore.put(tile);
        Assert.assertTrue((boolean)this.blobStore.layerExists(DEFAULT_LAYER));
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        String layerName = tile.getLayerName();
        this.blobStore.delete(layerName);
        ((BlobStoreListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.atLeastOnce())).layerDeleted((String)ArgumentMatchers.eq((Object)layerName));
        long start = System.currentTimeMillis();
        boolean t20Deleted = false;
        boolean t21Deleted = false;
        boolean t22Deleted = false;
        while (!(System.currentTimeMillis() - start >= 100000L || t20Deleted && t21Deleted && t22Deleted)) {
            if (!t20Deleted) {
                tile.getXYZ()[0] = 20L;
                boolean bl = t20Deleted = !this.blobStore.get(tile);
            }
            if (!t21Deleted) {
                tile.getXYZ()[0] = 21L;
                boolean bl = t21Deleted = !this.blobStore.get(tile);
            }
            if (!t22Deleted) {
                tile.getXYZ()[0] = 22L;
                boolean bl = t22Deleted = !this.blobStore.get(tile);
            }
            if (t20Deleted && t21Deleted && t22Deleted) continue;
            Thread.sleep(500L);
        }
        Assert.assertTrue((boolean)t20Deleted);
        Assert.assertTrue((boolean)t21Deleted);
        Assert.assertTrue((boolean)t22Deleted);
        Assert.assertFalse((boolean)this.blobStore.layerExists(DEFAULT_LAYER));
    }

    @Test
    public void testDeleteGridSubset() throws Exception {
        this.seed(0, 1, DEFAULT_GRIDSET, DEFAULT_FORMAT, null);
        this.seed(0, 1, DEFAULT_GRIDSET, "jpeg", (Map<String, String>)ImmutableMap.of((Object)"param", (Object)"value"));
        this.seed(0, 1, "EPSG:3857", DEFAULT_FORMAT, null);
        this.seed(0, 1, "EPSG:3857", "jpeg", (Map<String, String>)ImmutableMap.of((Object)"param", (Object)"value"));
        Assert.assertFalse((boolean)this.blobStore.deleteByGridsetId(DEFAULT_LAYER, "EPSG:26986"));
        Assert.assertTrue((boolean)this.blobStore.deleteByGridsetId(DEFAULT_LAYER, DEFAULT_GRIDSET));
        boolean t4326PngDeleted = false;
        boolean t4326JpegDeleted = false;
        long start = System.currentTimeMillis();
        while (!(System.currentTimeMillis() - start >= 100000L || t4326PngDeleted && t4326JpegDeleted)) {
            if (!t4326PngDeleted) {
                boolean bl = t4326PngDeleted = !this.blobStore.get(this.queryTile(DEFAULT_LAYER, DEFAULT_GRIDSET, DEFAULT_FORMAT, 0L, 0L, 0));
            }
            if (t4326JpegDeleted) continue;
            t4326JpegDeleted = !this.blobStore.get(this.queryTile(DEFAULT_LAYER, DEFAULT_GRIDSET, "jpeg", 0L, 0L, 0, "param", "value"));
        }
        Assert.assertTrue((boolean)t4326PngDeleted);
        Assert.assertTrue((boolean)t4326JpegDeleted);
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(DEFAULT_LAYER, "EPSG:3857", DEFAULT_FORMAT, 0L, 0L, 0)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(DEFAULT_LAYER, "EPSG:3857", "jpeg", 0L, 0L, 0, "param", "value")));
    }

    @Test
    public void testLayerMetadata() {
        this.blobStore.putLayerMetadata(DEFAULT_LAYER, "prop1", "value1");
        this.blobStore.putLayerMetadata(DEFAULT_LAYER, "prop2", "value2");
        Assert.assertNull((Object)this.blobStore.getLayerMetadata(DEFAULT_LAYER, "nonExistingKey"));
        Assert.assertEquals((Object)"value1", (Object)this.blobStore.getLayerMetadata(DEFAULT_LAYER, "prop1"));
        Assert.assertEquals((Object)"value2", (Object)this.blobStore.getLayerMetadata(DEFAULT_LAYER, "prop2"));
    }

    @Test
    public void testTruncateShortCutsIfNoTilesInParametersPrefix() throws StorageException, MimeException {
        boolean zoomStart = false;
        boolean zoomStop = true;
        this.seed(0, 1);
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        GridSet gridset = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false))).getWorldEpsg4326();
        GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)gridset);
        long[][] rangeBounds = new long[][]{gridSubSet.getCoverage(0), gridSubSet.getCoverage(1)};
        MimeType mimeType = MimeType.createFromExtension((String)DEFAULT_FORMAT);
        ImmutableMap parameters = ImmutableMap.of((Object)"someparam", (Object)"somevalue");
        TileRange tileRange = this.tileRange(DEFAULT_LAYER, DEFAULT_GRIDSET, 0, 1, rangeBounds, mimeType, (Map<String, String>)parameters);
        Assert.assertFalse((boolean)this.blobStore.delete(tileRange));
        ((BlobStoreListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).tileDeleted(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testTruncateShortCutsIfNoTilesInGridsetPrefix() throws StorageException, MimeException {
        boolean zoomStart = false;
        boolean zoomStop = true;
        this.seed(0, 1);
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        GridSet gridset = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, true))).getWorldEpsg3857();
        GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)gridset);
        long[][] rangeBounds = new long[][]{gridSubSet.getCoverage(0), gridSubSet.getCoverage(1)};
        MimeType mimeType = MimeType.createFromExtension((String)DEFAULT_FORMAT);
        Map<String, String> parameters = null;
        TileRange tileRange = this.tileRange(DEFAULT_LAYER, gridset.getName(), 0, 1, rangeBounds, mimeType, parameters);
        Assert.assertFalse((boolean)this.blobStore.delete(tileRange));
        ((BlobStoreListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).tileDeleted(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testTruncateRespectsLevels() throws StorageException, MimeException {
        boolean zoomStart = false;
        int zoomStop = 2;
        GridSet gridset = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, true))).getWorldEpsg3857();
        GridSubset gridSubSet = GridSubsetFactory.createGridSubSet((GridSet)gridset);
        long[][] rangeBounds = gridSubSet.getCoverages();
        this.seed(0, 2, gridset.getName(), DEFAULT_FORMAT, null);
        BlobStoreListener listener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.blobStore.addListener(listener);
        MimeType mimeType = MimeType.createFromExtension((String)DEFAULT_FORMAT);
        Map<String, String> parameters = null;
        boolean truncateStart = false;
        boolean truncateStop = true;
        TileRange tileRange = this.tileRange(DEFAULT_LAYER, gridset.getName(), 0, 1, rangeBounds, mimeType, parameters);
        Assert.assertTrue((boolean)this.blobStore.delete(tileRange));
        int expectedCount = 5;
        ((BlobStoreListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)expectedCount))).tileDeleted(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testTruncateOptimizationIfNoListeners() throws StorageException, MimeException {
        boolean zoomStart = false;
        int zoomStop = 2;
        long[][] rangeBounds = new long[][]{{0L, 0L, 0L, 0L, 0L}, {0L, 0L, 1L, 1L, 1L}, {0L, 0L, 3L, 3L, 2L}};
        this.seed(0, 2);
        MimeType mimeType = MimeType.createFromExtension((String)DEFAULT_FORMAT);
        Map<String, String> parameters = null;
        boolean truncateStart = false;
        boolean truncateStop = true;
        TileRange tileRange = this.tileRange(DEFAULT_LAYER, DEFAULT_GRIDSET, 0, 1, rangeBounds, mimeType, parameters);
        this.blobStore = (AzureBlobStore)Mockito.spy((Object)this.blobStore);
        Assert.assertTrue((boolean)this.blobStore.delete(tileRange));
        ((AzureBlobStore)Mockito.verify((Object)this.blobStore, (VerificationMode)Mockito.times((int)0))).delete((TileObject)Mockito.any(TileObject.class));
        Assert.assertFalse((boolean)this.blobStore.get(this.queryTile(0L, 0L, 0)));
        Assert.assertFalse((boolean)this.blobStore.get(this.queryTile(0L, 0L, 1)));
        Assert.assertFalse((boolean)this.blobStore.get(this.queryTile(0L, 1L, 1)));
        Assert.assertFalse((boolean)this.blobStore.get(this.queryTile(1L, 0L, 1)));
        Assert.assertFalse((boolean)this.blobStore.get(this.queryTile(1L, 1L, 1)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(0L, 0L, 2)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(0L, 1L, 2)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(0L, 2L, 2)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(3L, 0L, 2)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(3L, 1L, 2)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(3L, 2L, 2)));
        Assert.assertTrue((boolean)this.blobStore.get(this.queryTile(3L, 3L, 2)));
    }

    private TileRange tileRange(String layerName, String gridSetId, int zoomStart, int zoomStop, long[][] rangeBounds, MimeType mimeType, Map<String, String> parameters) {
        TileRange tileRange = new TileRange(layerName, gridSetId, zoomStart, zoomStop, rangeBounds, mimeType, parameters);
        return tileRange;
    }

    private void seed(int zoomStart, int zoomStop) throws StorageException {
        this.seed(zoomStart, zoomStop, DEFAULT_GRIDSET, DEFAULT_FORMAT, null);
    }

    private void seed(int zoomStart, int zoomStop, String gridset, String formatExtension, Map<String, String> parameters) throws StorageException {
        Preconditions.checkArgument((zoomStop < 5 ? 1 : 0) != 0, (Object)"don't use high zoom levels for integration testing");
        for (int z = zoomStart; z <= zoomStop; ++z) {
            int max = (int)Math.pow(2.0, z);
            for (int x = 0; x < max; ++x) {
                for (int y = 0; y < max; ++y) {
                    log.fine(String.format("seeding %d,%d,%d", x, y, z));
                    this.put(x, y, z, gridset, formatExtension, parameters);
                }
            }
        }
    }

    private TileObject put(long x, long y, int z, String gridset, String formatExtension, Map<String, String> parameters) throws StorageException {
        return this.put(x, y, z, DEFAULT_LAYER, gridset, formatExtension, parameters);
    }

    private TileObject put(long x, long y, int z, String layerName, String gridset, String formatExtension, Map<String, String> parameters) throws StorageException {
        byte[] bytes = new byte[256];
        Arrays.fill(bytes, (byte)-81);
        TileObject tile = this.queryTile(layerName, gridset, formatExtension, x, y, z, parameters);
        tile.setBlob((Resource)new ByteArrayResource(bytes));
        this.blobStore.put(tile);
        return tile;
    }

    private TileObject queryTile(long x, long y, int z) {
        return this.queryTile(DEFAULT_LAYER, DEFAULT_GRIDSET, DEFAULT_FORMAT, x, y, z);
    }

    private TileObject queryTile(String layer, String gridset, String extension, long x, long y, int z) {
        return this.queryTile(layer, gridset, extension, x, y, z, (Map<String, String>)null);
    }

    private TileObject queryTile(String layer, String gridset, String extension, long x, long y, int z, String ... parameters) {
        HashMap<String, String> parametersMap = null;
        if (parameters != null) {
            parametersMap = new HashMap<String, String>();
            for (int i = 0; i < parameters.length; i += 2) {
                parametersMap.put(parameters[i], parameters[i + 1]);
            }
        }
        return this.queryTile(layer, gridset, extension, x, y, z, parametersMap);
    }

    private TileObject queryTile(String layer, String gridset, String extension, long x, long y, int z, Map<String, String> parameters) {
        String format;
        try {
            format = MimeType.createFromExtension((String)extension).getFormat();
        }
        catch (MimeException e) {
            throw new RuntimeException(e);
        }
        TileObject tile = TileObject.createQueryTileObject((String)layer, (long[])new long[]{x, y, z}, (String)gridset, (String)format, parameters);
        return tile;
    }
}

